/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.google.common.io.Closeables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.framework.ui.ChooseModulePanel;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.RepositoryDescription;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;

public class ConfigureDialogWithModulesAndVersion
extends DialogWrapper {
    private static final String VERSIONS_LIST_URL = "https://search.maven.org/solrsearch/select?q=g:%22org.jetbrains.kotlin%22+AND+a:%22kotlin-stdlib%22&core=gav&rows=20&wt=json";
    private static final String DEFAULT_KOTLIN_VERSION = "1.8.21";
    @NotNull
    private final String minimumVersion;
    private final Map<String, List<String>> jvmModulesTargetingUnsupportedJvm;
    private final Map<String, String> modulesAndJvmTargets;
    private final ChooseModulePanel chooseModulePanel;
    private JPanel contentPane;
    private JPanel chooseModulesPanelPlace;
    private JComboBox<String> kotlinVersionComboBox;
    private JPanel infoPanel;
    private JTextPane deprecatedJvmTargetsUsedWarning;
    private final AsyncProcessIcon processIcon;
    private static final int MODULES_TO_DISPLAY_SIZE = 2;
    private static final String DELIMITER = ", ";

    public ConfigureDialogWithModulesAndVersion(@NotNull Project project2, @NotNull KotlinProjectConfigurator configurator, @NotNull Collection<Module> excludeModules, @NotNull String minimumVersion) {
        if (project2 == null) {
            ConfigureDialogWithModulesAndVersion.$$$reportNull$$$0(0);
        }
        if (configurator == null) {
            ConfigureDialogWithModulesAndVersion.$$$reportNull$$$0(1);
        }
        if (excludeModules == null) {
            ConfigureDialogWithModulesAndVersion.$$$reportNull$$$0(2);
        }
        if (minimumVersion == null) {
            ConfigureDialogWithModulesAndVersion.$$$reportNull$$$0(3);
        }
        super(project2);
        this.$$$setupUI$$$();
        this.processIcon = new AsyncProcessIcon("loader");
        KotlinJ2KOnboardingFUSCollector.Companion.logShowConfigureKtWindow(project2);
        this.setTitle(KotlinProjectConfigurationBundle.message("configure.kotlin.title", configurator.getPresentableText()));
        this.minimumVersion = minimumVersion;
        this.init();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, KotlinProjectConfigurationBundle.message("configure.kotlin.find.maven.versions", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ConfigureDialogWithModulesAndVersion.this.loadKotlinVersions();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion$1", "run"));
            }
        });
        this.kotlinVersionComboBox.addActionListener(e -> this.updateComponents());
        this.kotlinVersionComboBox.addItem(KotlinProjectConfigurationBundle.message("configure.kotlin.loading", new Object[0]));
        this.kotlinVersionComboBox.setEnabled(false);
        this.processIcon.resume();
        this.infoPanel.add((Component)this.processIcon, "Center");
        this.chooseModulePanel = new ChooseModulePanel(project2, configurator, excludeModules);
        this.chooseModulesPanelPlace.add((Component)this.chooseModulePanel.getContentPane(), "Center");
        Pair<Map<String, List<String>>, Map<String, String>> jvmTargets = ConfigureKotlinInProjectUtilsKt.getModulesTargetingUnsupportedJvmAndTargetsForAllModules(this.chooseModulePanel.getModules(), IdeKotlinVersion.get(DEFAULT_KOTLIN_VERSION));
        this.jvmModulesTargetingUnsupportedJvm = (Map)jvmTargets.getFirst();
        this.modulesAndJvmTargets = (Map)jvmTargets.getSecond();
        this.showUnsupportedJvmTargetWarning();
        this.updateComponents();
    }

    private void showUnsupportedJvmTargetWarning() {
        if (!this.jvmModulesTargetingUnsupportedJvm.isEmpty()) {
            StringBuilder message2 = new StringBuilder();
            message2.append(KotlinProjectConfigurationBundle.message("configurator.kotlin.jvm.targets.unsupported", "1.8"));
            this.jvmModulesTargetingUnsupportedJvm.keySet().stream().sorted().forEach(jvmTargetVersion -> {
                List<String> modulesWithThisTargetVersion = this.jvmModulesTargetingUnsupportedJvm.get(jvmTargetVersion);
                StringBuilder modulesEnumeration = new StringBuilder();
                if (modulesWithThisTargetVersion.size() > 2) {
                    modulesEnumeration.append(modulesWithThisTargetVersion.stream().limit(2L).sorted().collect(Collectors.joining(DELIMITER)));
                    modulesEnumeration.append(KotlinProjectConfigurationBundle.message("configure.kotlin.jvm.target.in.nodules.and.more", modulesWithThisTargetVersion.size() - 2));
                } else {
                    modulesEnumeration.append(modulesWithThisTargetVersion.stream().sorted().collect(Collectors.joining(DELIMITER)));
                }
                message2.append(KotlinProjectConfigurationBundle.message("configurator.kotlin.jvm.target.in.modules", jvmTargetVersion, modulesEnumeration.toString()));
            });
            message2.append(KotlinProjectConfigurationBundle.message("configurator.kotlin.jvm.target.bump.manually.learn.more", new Object[0]));
            Messages.installHyperlinkSupport((JTextPane)this.deprecatedJvmTargetsUsedWarning);
            this.deprecatedJvmTargetsUsedWarning.setText(message2.toString());
            this.deprecatedJvmTargetsUsedWarning.setVisible(true);
        } else {
            this.deprecatedJvmTargetsUsedWarning.setVisible(false);
        }
    }

    public List<Module> getModulesToConfigure() {
        return this.chooseModulePanel.getModulesToConfigure();
    }

    public String getKotlinVersion() {
        return (String)this.kotlinVersionComboBox.getSelectedItem();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    private void loadKotlinVersions() {
        Collection<String> items;
        try {
            items = ConfigureDialogWithModulesAndVersion.loadVersions(this.minimumVersion);
            this.hideLoader();
        }
        catch (Throwable t) {
            items = Collections.singletonList("1.0.0");
            this.showWarning();
        }
        this.updateVersions(items);
    }

    private void hideLoader() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.infoPanel.setVisible(false);
            this.infoPanel.updateUI();
        }, ModalityState.stateForComponent((Component)this.infoPanel));
    }

    private void showWarning() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.infoPanel.remove((Component)this.processIcon);
            this.infoPanel.add((Component)new JLabel(UIUtil.getBalloonWarningIcon()), "Center");
            this.infoPanel.setToolTipText(KotlinProjectConfigurationBundle.message("configure.kotlin.cant.load.versions", new Object[0]));
            this.infoPanel.setCursor(Cursor.getPredefinedCursor(12));
            this.infoPanel.updateUI();
        }, ModalityState.stateForComponent((Component)this.infoPanel));
    }

    private void updateVersions(@NotNull Collection<String> newItems) {
        if (newItems == null) {
            ConfigureDialogWithModulesAndVersion.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            this.kotlinVersionComboBox.removeAllItems();
            this.kotlinVersionComboBox.setEnabled(true);
            for (String newItem : newItems) {
                this.kotlinVersionComboBox.addItem(newItem);
            }
            this.kotlinVersionComboBox.setSelectedIndex(0);
        }, ModalityState.stateForComponent(this.kotlinVersionComboBox));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Collection<String> loadVersions(String minimumVersion) throws IOException {
        int timeout;
        ArrayList<String> versions = new ArrayList<String>();
        IdeKotlinVersion kotlinCompilerVersion = KotlinPluginLayout.getStandaloneCompilerVersion();
        String kotlinArtifactVersion = kotlinCompilerVersion.getArtifactVersion();
        RepositoryDescription repositoryDescription = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion(kotlinCompilerVersion);
        if (repositoryDescription != null && repositoryDescription.getBintrayUrl() != null) {
            HttpURLConnection eapConnection = HttpConfigurable.getInstance().openHttpConnection(repositoryDescription.getBintrayUrl() + kotlinArtifactVersion);
            try {
                timeout = (int)TimeUnit.SECONDS.toMillis(30L);
                eapConnection.setConnectTimeout(timeout);
                eapConnection.setReadTimeout(timeout);
                if (eapConnection.getResponseCode() == 200) {
                    versions.add(kotlinArtifactVersion);
                }
            }
            finally {
                eapConnection.disconnect();
            }
        }
        HttpURLConnection urlConnection = HttpConfigurable.getInstance().openHttpConnection(VERSIONS_LIST_URL);
        try {
            timeout = (int)TimeUnit.SECONDS.toMillis(30L);
            urlConnection.setConnectTimeout(timeout);
            urlConnection.setReadTimeout(timeout);
            urlConnection.connect();
            InputStreamReader streamReader = new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8);
            try {
                JsonElement rootElement = JsonParser.parseReader((Reader)streamReader);
                JsonArray docsElements = rootElement.getAsJsonObject().get("response").getAsJsonObject().get("docs").getAsJsonArray();
                for (JsonElement element3 : docsElements) {
                    String versionNumber = element3.getAsJsonObject().get("v").getAsString();
                    if (VersionComparatorUtil.compare((String)minimumVersion, (String)versionNumber) > 0) continue;
                    versions.add(versionNumber);
                }
            }
            finally {
                Closeables.closeQuietly((Reader)streamReader);
            }
        }
        finally {
            urlConnection.disconnect();
        }
        Collections.sort(versions, VersionComparatorUtil.COMPARATOR.reversed());
        if (kotlinCompilerVersion.isRelease() && !versions.contains(kotlinArtifactVersion)) {
            versions.add(0, kotlinArtifactVersion);
        }
        ArrayList<String> arrayList = versions;
        if (arrayList == null) {
            ConfigureDialogWithModulesAndVersion.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private void updateComponents() {
        this.setOKActionEnabled(this.kotlinVersionComboBox.isEnabled());
    }

    public Map<String, String> getModulesAndJvmTargets() {
        return this.modulesAndJvmTargets;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.contentPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setPreferredSize(new Dimension(600, 300));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinProjectConfigurationBundle", ConfigureDialogWithModulesAndVersion.class).getString("kotlin.compiler.and.runtime.version"));
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.kotlinVersionComboBox = jComboBox;
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.infoPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 2, 1, 1, 0, 3, 0, 0, new Dimension(20, -1), new Dimension(20, -1), new Dimension(20, -1)));
        this.chooseModulesPanelPlace = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.deprecatedJvmTargetsUsedWarning = jTextPane = new JTextPane();
        jTextPane.setContentType("text/plain");
        jTextPane.setEditable(false);
        ((Component)jTextPane).setEnabled(true);
        ((Component)jTextPane).setVisible(false);
        jPanel4.add((Component)jTextPane, new GridConstraints(2, 0, 1, 1, 1, 1, 7, 3, null, new Dimension(450, 50), null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeModules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItems";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateVersions";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5 -> new IllegalStateException(string2);
        };
    }
}

