/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeAction;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "hasOverriddenEqualsAndHashCode", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "GenerateEqualsAndHashcodeFix", "kotlin.idea"})
public final class ArrayInDataClassInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)VisitorWrappersKt.classVisitor((Function1)((Function1)new Function1<KtClass, Unit>(this, holder){
            final /* synthetic */ ArrayInDataClassInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtClass klass2) {
                Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
                if (!klass2.isData()) {
                    return;
                }
                KtPrimaryConstructor ktPrimaryConstructor = klass2.getPrimaryConstructor();
                if (ktPrimaryConstructor == null) {
                    return;
                }
                KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
                if (ArrayInDataClassInspection.access$hasOverriddenEqualsAndHashCode(this.this$0, klass2)) {
                    return;
                }
                BindingContext context2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)constructor2, BodyResolveMode.PARTIAL);
                for (KtParameter parameter2 : constructor2.getValueParameters()) {
                    KotlinType type2;
                    if (!parameter2.hasValOrVar() || (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)parameter2.getTypeReference()) == null || !KotlinBuiltIns.isArray((KotlinType)type2) && !KotlinBuiltIns.isPrimitiveArray((KotlinType)type2)) continue;
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new GenerateEqualsAndHashcodeFix()};
                    this.$holder.registerProblem((PsiElement)parameter2, KotlinBundle.message("array.property.in.data.class.it.s.recommended.to.override.equals.hashcode", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
                }
            }
        }));
    }

    private final boolean hasOverriddenEqualsAndHashCode(KtClass klass2) {
        boolean overriddenEquals = false;
        boolean overriddenHashCode = false;
        for (KtDeclaration declaration2 : klass2.getDeclarations()) {
            if (!(declaration2 instanceof KtFunction) || !declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) continue;
            if (Intrinsics.areEqual((Object)((KtFunction)declaration2).getNameAsName(), (Object)OperatorNameConventions.EQUALS) && ((KtFunction)declaration2).getValueParameters().size() == 1) {
                KotlinType type2;
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(declaration2, null, 1, null);
                Object object = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                KotlinType kotlinType = object != null && (object = object.getValueParameters()) != null && (object = (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)object)) != null ? object.getType() : (type2 = null);
                if (type2 != null && KotlinBuiltIns.isNullableAny(type2)) {
                    overriddenEquals = true;
                }
            }
            if (!Intrinsics.areEqual((Object)((KtFunction)declaration2).getName(), (Object)"hashCode") || ((KtFunction)declaration2).getValueParameters().size() != 0) continue;
            overriddenHashCode = true;
        }
        return overriddenEquals && overriddenHashCode;
    }

    public static final /* synthetic */ boolean access$hasOverriddenEqualsAndHashCode(ArrayInDataClassInspection $this, KtClass klass2) {
        return $this.hasOverriddenEqualsAndHashCode(klass2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection$GenerateEqualsAndHashcodeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "startInWriteAction", "", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nArrayInDataClassInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayInDataClassInspection.kt\norg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection$GenerateEqualsAndHashcodeFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,83:1\n146#2:84\n*S KotlinDebug\n*F\n+ 1 ArrayInDataClassInspection.kt\norg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection$GenerateEqualsAndHashcodeFix\n*L\n77#1:84\n*E\n"})
    public static final class GenerateEqualsAndHashcodeFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("generate.equals.and.hashcode.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
                    return;
                }
                PsiElement psiElement2 = descriptor2.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
                PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
                boolean $i$f$getNonStrictParentOfType = false;
                KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClass.class, (boolean)false);
                if (ktClass2 == null) break block1;
                KtClass $this$applyFix_u24lambda_u240 = ktClass2;
                boolean bl = false;
                KotlinGenerateEqualsAndHashcodeAction kotlinGenerateEqualsAndHashcodeAction = new KotlinGenerateEqualsAndHashcodeAction();
                PsiElement psiElement3 = descriptor2.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"descriptor.psiElement");
                kotlinGenerateEqualsAndHashcodeAction.doInvoke(project2, EditorUtilsKt.findExistingEditor(psiElement3), (KtClassOrObject)$this$applyFix_u24lambda_u240);
            }
        }
    }
}

