/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.SuspiciousCollectionReassignmentInspectionKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiUnifierKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0002J!\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0005H\u0082\u0010J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithOperatorAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "buildOperatorAssignment", "buildOperatorAssignmentText", "variableExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "tail", "checkExpressionRepeat", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "fixText", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "inspectionText", "isApplicable", "isArithmeticOperation", "operationToken", "Lcom/intellij/psi/tree/IElementType;", "isCommutative", "kotlin.idea"})
public final class ReplaceWithOperatorAssignmentInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    public ReplaceWithOperatorAssignmentInspection() {
        super(KtBinaryExpression.class);
    }

    @Override
    public boolean isApplicable(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!Intrinsics.areEqual((Object)element3.getOperationToken(), (Object)KtTokens.EQ)) {
            return false;
        }
        KtExpression ktExpression = element3.getLeft();
        if (ktExpression == null) {
            return false;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = element3.getRight();
        KtBinaryExpression ktBinaryExpression = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression right2 = ktBinaryExpression;
        if (right2.getLeft() == null || right2.getRight() == null) {
            return false;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)right2, BodyResolveMode.PARTIAL_WITH_CFA);
        if (!this.checkExpressionRepeat(left, right2, bindingContext2)) {
            return false;
        }
        KtBinaryExpression ktBinaryExpression2 = this.buildOperatorAssignment(element3);
        if (ktBinaryExpression2 == null) {
            return false;
        }
        KtBinaryExpression opAssign = ktBinaryExpression2;
        KtFile ktFile = opAssign.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"opAssign.containingKtFile");
        KtPsiFactoryKt.setDoNotAnalyze((KtFile)ktFile, null);
        BindingContext newBindingContext = ExtendedResolutionApiKt.analyzeAsReplacement$default((KtExpression)opAssign, (KtExpression)element3, bindingContext2, null, null, null, 28, null);
        Diagnostics diagnostics2 = newBindingContext.getDiagnostics();
        KtOperationReferenceExpression ktOperationReferenceExpression = opAssign.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"opAssign.operationReference");
        return diagnostics2.forElement((PsiElement)ktOperationReferenceExpression).isEmpty();
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("replaceable.with.operator.assignment", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("replace.with.operator.assignment", new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Object[] objectArray = new Object[1];
        KtExpression ktExpression = element3.getRight();
        KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        objectArray[0] = (ktBinaryExpression != null && (ktBinaryExpression = ktBinaryExpression.getOperationReference()) != null && (ktBinaryExpression = ktBinaryExpression.getOperationSignTokenType()) != null ? ktBinaryExpression.getValue() : null) + "=";
        return KotlinBundle.message("replace.with.0", objectArray);
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtBinaryExpression element3) {
        KtNameReferenceExpression left;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getLeft();
        KtNameReferenceExpression ktNameReferenceExpression = left = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (left != null) {
            KotlinType leftType;
            BindingContext context2 = ResolutionUtils.analyze((KtElement)left, BodyResolveMode.PARTIAL);
            KotlinType kotlinType = leftType = CallUtilKt.getType((KtExpression)((KtExpression)left), (BindingContext)context2);
            boolean bl = kotlinType != null ? SuspiciousCollectionReassignmentInspectionKt.isReadOnlyCollectionOrMap(kotlinType, PlatformKt.getBuiltIns((KtElement)element3)) : false;
            if (bl) {
                return ProblemHighlightType.INFORMATION;
            }
        }
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    private final boolean checkExpressionRepeat(KtExpression variableExpression, KtBinaryExpression expression2, BindingContext bindingContext2) {
        boolean bl;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expression2.getOperationReference());
        DeclarationDescriptor descriptor2 = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        boolean isPrimitiveOperation = descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isPrimitiveType((KotlinType)((KotlinType)((ClassDescriptor)descriptor2).getDefaultType()));
        IElementType iElementType = expression2.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expression.operationToken");
        IElementType operationToken = iElementType;
        KtExpression expressionLeft = expression2.getLeft();
        KtExpression expressionRight = expression2.getRight();
        if (KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expressionLeft)) {
            bl = this.isArithmeticOperation(operationToken);
        } else if (KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expressionRight)) {
            bl = isPrimitiveOperation && this.isCommutative(operationToken);
        } else if (expressionLeft instanceof KtBinaryExpression) {
            boolean sameCommutativeOperation;
            boolean bl2 = sameCommutativeOperation = Intrinsics.areEqual((Object)((KtBinaryExpression)expressionLeft).getOperationToken(), (Object)operationToken) && this.isCommutative(operationToken);
            bl = isPrimitiveOperation && sameCommutativeOperation && this.checkExpressionRepeat(variableExpression, (KtBinaryExpression)expressionLeft, bindingContext2);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCommutative(IElementType operationToken) {
        return Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MUL);
    }

    private final boolean isArithmeticOperation(IElementType operationToken) {
        return Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MUL) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.DIV) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PERC);
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KtBinaryExpression ktBinaryExpression = this.buildOperatorAssignment(element3);
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression operatorAssignment = ktBinaryExpression;
        element3.replace((PsiElement)operatorAssignment);
    }

    private final KtBinaryExpression buildOperatorAssignment(KtBinaryExpression element3) {
        KtExpression ktExpression = element3.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression variableExpression = ktExpression;
        KtExpression ktExpression2 = element3.getRight();
        KtBinaryExpression ktBinaryExpression = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression assignedExpression = ktBinaryExpression;
        String replacement2 = this.buildOperatorAssignmentText(variableExpression, assignedExpression, "");
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        KtExpression ktExpression3 = new KtPsiFactory(project2, false, 2, null).createExpression(replacement2);
        Intrinsics.checkNotNull((Object)ktExpression3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        return (KtBinaryExpression)ktExpression3;
    }

    private final String buildOperatorAssignmentText(KtExpression variableExpression, KtBinaryExpression expression2, String tail) {
        String string2;
        block3: {
            while (true) {
                String operationText = expression2.getOperationReference().getText();
                String variableName = variableExpression.getText();
                if (KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expression2.getLeft())) {
                    KtExpression ktExpression = expression2.getRight();
                    Intrinsics.checkNotNull((Object)ktExpression);
                    string2 = ReplaceWithOperatorAssignmentInspection.buildOperatorAssignmentText$appendTail(variableName + " " + operationText + "= " + ktExpression.getText(), tail);
                    break block3;
                }
                if (KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expression2.getRight())) {
                    KtExpression ktExpression = expression2.getLeft();
                    Intrinsics.checkNotNull((Object)ktExpression);
                    string2 = ReplaceWithOperatorAssignmentInspection.buildOperatorAssignmentText$appendTail(variableName + " " + operationText + "= " + ktExpression.getText(), tail);
                    break block3;
                }
                if (!(expression2.getLeft() instanceof KtBinaryExpression)) break;
                ReplaceWithOperatorAssignmentInspection replaceWithOperatorAssignmentInspection = this_;
                KtExpression ktExpression = variableExpression;
                KtExpression ktExpression2 = expression2.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression2;
                KtExpression ktExpression3 = expression2.getRight();
                Intrinsics.checkNotNull((Object)ktExpression3);
                String string3 = ReplaceWithOperatorAssignmentInspection.buildOperatorAssignmentText$appendTail(operationText + " " + ktExpression3.getText(), tail);
                ReplaceWithOperatorAssignmentInspection this_ = replaceWithOperatorAssignmentInspection;
                variableExpression = ktExpression;
                expression2 = ktBinaryExpression;
                tail = string3;
            }
            string2 = tail;
        }
        return string2;
    }

    private static final String buildOperatorAssignmentText$appendTail(String $this$buildOperatorAssignmentText_u24appendTail, String $tail) {
        return ((CharSequence)$tail).length() == 0 ? $this$buildOperatorAssignmentText_u24appendTail : $this$buildOperatorAssignmentText_u24appendTail + " " + $tail;
    }
}

