/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInspection.dataFlow.jvm.descriptors.JvmVariableDescriptor;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.idea.inspections.dfa.KtLambdaSpecialVariableDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.KtThisDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.LambdaAndParameter;
import org.jetbrains.kotlin.idea.inspections.dfa.LambdaVariableKind;
import org.jetbrains.kotlin.idea.refactoring.move.moveMethod.MoveKotlinMethodProcessorKt;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.util.CollectionUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\u0006H\u0016J\u0013\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtVariableDescriptor;", "Lcom/intellij/codeInspection/dataFlow/jvm/descriptors/JvmVariableDescriptor;", "variable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;)V", "stable", "", "getStable", "()Z", "getVariable", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "calculateStable", "canBeCapturedInClosure", "equals", "other", "", "getDfType", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "qualifier", "Lcom/intellij/codeInspection/dataFlow/value/DfaVariableValue;", "getPsiElement", "getVariablesChangedInNestedFunctions", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "parent", "Lcom/intellij/psi/PsiElement;", "hashCode", "", "isStable", "toString", "", "Companion", "kotlin.idea"})
public final class KtVariableDescriptor
extends JvmVariableDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCallableDeclaration variable;
    private final boolean stable;

    public KtVariableDescriptor(@NotNull KtCallableDeclaration variable2) {
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        this.variable = variable2;
        this.stable = this.calculateStable();
    }

    @NotNull
    public final KtCallableDeclaration getVariable() {
        return this.variable;
    }

    public final boolean getStable() {
        return this.stable;
    }

    private final boolean calculateStable() {
        if (this.variable instanceof KtParameter && ((KtParameter)this.variable).isMutable()) {
            return false;
        }
        if (!(this.variable instanceof KtProperty) || !((KtProperty)this.variable).isVar()) {
            return true;
        }
        if (!((KtProperty)this.variable).isLocal()) {
            return false;
        }
        PsiElement psiElement2 = ((KtProperty)this.variable).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"variable.parent");
        return !this.getVariablesChangedInNestedFunctions(psiElement2).contains(this.variable);
    }

    private final Set<KtProperty> getVariablesChangedInNestedFunctions(PsiElement parent2) {
        Object object = CachedValuesManager.getProjectPsiDependentCache((PsiElement)parent2, arg_0 -> KtVariableDescriptor.getVariablesChangedInNestedFunctions$lambda$0((Function1)new Function1<PsiElement, HashSet<KtProperty>>(parent2){
            final /* synthetic */ PsiElement $parent;
            {
                this.$parent = $parent;
                super(1);
            }

            public final HashSet<KtProperty> invoke(PsiElement scope2) {
                HashSet<KtProperty> result2 = new HashSet<KtProperty>();
                PsiTreeUtil.processElements((PsiElement)scope2, (PsiElementProcessor)new PsiElementProcessor(this.$parent, result2){
                    final /* synthetic */ PsiElement $parent;
                    final /* synthetic */ HashSet<KtProperty> $result;
                    {
                        this.$parent = $parent;
                        this.$result = $result;
                    }

                    public final boolean execute(@NotNull PsiElement e) {
                        PsiElement target2;
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (e instanceof KtSimpleNameExpression && ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)((KtExpression)e), (boolean)false).isWrite() && (target2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)e)).resolve()) instanceof KtProperty && ((KtProperty)target2).isLocal() && PsiTreeUtil.isAncestor((PsiElement)this.$parent, (PsiElement)target2, (boolean)true)) {
                            KtFunction parentScope = null;
                            PsiElement context2 = e;
                            while (true) {
                                KtCallExpression maybeCall;
                                KtLambdaExpression maybeLambda;
                                KtFunction ktFunction = parentScope = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)context2, KtFunction.class);
                                PsiElement psiElement2 = ktFunction != null ? ktFunction.getParent() : null;
                                KtLambdaExpression ktLambdaExpression2 = maybeLambda = psiElement2 instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement2 : null;
                                PsiElement psiElement3 = ktLambdaExpression2 != null ? ktLambdaExpression2.getParent() : null;
                                KtLambdaArgument ktLambdaArgument = psiElement3 instanceof KtLambdaArgument ? (KtLambdaArgument)psiElement3 : null;
                                PsiElement psiElement4 = ktLambdaArgument != null ? ktLambdaArgument.getParent() : null;
                                KtCallExpression ktCallExpression = maybeCall = psiElement4 instanceof KtCallExpression ? (KtCallExpression)psiElement4 : null;
                                if (maybeCall == null) break;
                                LambdaAndParameter lambdaAndParameter = KtDfaHelpersKt.getInlineableLambda(maybeCall);
                                if (!Intrinsics.areEqual((Object)(lambdaAndParameter != null ? lambdaAndParameter.getLambda() : null), (Object)maybeLambda)) break;
                                context2 = (PsiElement)maybeCall;
                            }
                            if (parentScope != null && PsiTreeUtil.isAncestor((PsiElement)this.$parent, (PsiElement)((PsiElement)parentScope), (boolean)true)) {
                                this.$result.add((KtProperty)target2);
                            }
                        }
                        return true;
                    }
                });
                return result2;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parent: PsiElement): Set\u2026entCache result\n        }");
        return (Set)object;
    }

    public boolean isStable() {
        return this.stable;
    }

    public boolean canBeCapturedInClosure() {
        if (this.variable instanceof KtParameter && ((KtParameter)this.variable).isMutable()) {
            return false;
        }
        return !(this.variable instanceof KtProperty) || !((KtProperty)this.variable).isVar();
    }

    @NotNull
    public KtCallableDeclaration getPsiElement() {
        return this.variable;
    }

    @NotNull
    public DfType getDfType(@Nullable DfaVariableValue qualifier2) {
        return KtDfaHelpersKt.toDfType(MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)this.variable));
    }

    public boolean equals(@Nullable Object other2) {
        return other2 instanceof KtVariableDescriptor && Intrinsics.areEqual((Object)((KtVariableDescriptor)((Object)other2)).variable, (Object)this.variable);
    }

    public int hashCode() {
        return this.variable.hashCode();
    }

    @NotNull
    public String toString() {
        String string2 = this.variable.getName();
        if (string2 == null) {
            string2 = "<unknown>";
        }
        return string2;
    }

    private static final HashSet getVariablesChangedInNestedFunctions$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashSet)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtVariableDescriptor$Companion;", "", "()V", "createFromQualified", "Lcom/intellij/codeInspection/dataFlow/value/DfaVariableValue;", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "createFromSimpleName", "getLambdaReceiver", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "getSingleLambdaParameter", "isTrackableProperty", "", "target", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DfaVariableValue getSingleLambdaParameter(@NotNull DfaValueFactory factory2, @NotNull KtLambdaExpression lambda2) {
            Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
            List list2 = lambda2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"lambda.valueParameters");
            List parameters2 = list2;
            if (parameters2.size() > 1) {
                return null;
            }
            if (parameters2.size() == 1) {
                DfaVariableValue dfaVariableValue;
                if (((KtParameter)parameters2.get(0)).getDestructuringDeclaration() == null) {
                    DfaVariableValue.Factory factory3 = factory2.getVarFactory();
                    Object e = parameters2.get(0);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"parameters[0]");
                    dfaVariableValue = factory3.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)e));
                } else {
                    dfaVariableValue = null;
                }
                return dfaVariableValue;
            }
            Object object = UtilsKt.resolveType$default((KtExpression)lambda2, null, 1, null);
            if (object == null || (object = FunctionTypesKt.getValueParameterTypesFromFunctionType((KotlinType)object)) == null || (object = (TypeProjection)CollectionsKt.singleOrNull((List)object)) == null || (object = object.getType()) == null) {
                return null;
            }
            Object kotlinType = object;
            KtFunctionLiteral ktFunctionLiteral = lambda2.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambda.functionLiteral");
            KtLambdaSpecialVariableDescriptor descriptor2 = new KtLambdaSpecialVariableDescriptor(ktFunctionLiteral, LambdaVariableKind.IT, (KotlinType)kotlinType);
            return factory2.getVarFactory().createVariableValue((VariableDescriptor)descriptor2);
        }

        @Nullable
        public final DfaVariableValue getLambdaReceiver(@NotNull DfaValueFactory factory2, @NotNull KtLambdaExpression lambda2) {
            Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
            KotlinType kotlinType = UtilsKt.resolveType$default((KtExpression)lambda2, null, 1, null);
            if (kotlinType == null || (kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType((KotlinType)kotlinType)) == null) {
                return null;
            }
            KotlinType receiverType2 = kotlinType;
            KtFunctionLiteral ktFunctionLiteral = lambda2.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambda.functionLiteral");
            KtLambdaSpecialVariableDescriptor descriptor2 = new KtLambdaSpecialVariableDescriptor(ktFunctionLiteral, LambdaVariableKind.THIS, receiverType2);
            return factory2.getVarFactory().createVariableValue((VariableDescriptor)descriptor2);
        }

        @Nullable
        public final DfaVariableValue createFromQualified(@NotNull DfaValueFactory factory2, @Nullable KtExpression expr) {
            Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
            KtExpression selector2 = expr;
            while (selector2 instanceof KtQualifiedExpression) {
                selector2 = ((KtQualifiedExpression)selector2).getSelectorExpression();
            }
            return this.createFromSimpleName(factory2, selector2);
        }

        @Nullable
        public final DfaVariableValue createFromSimpleName(@NotNull DfaValueFactory factory2, @Nullable KtExpression expr) {
            Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
            DfaVariableValue.Factory factory3 = factory2.getVarFactory();
            Intrinsics.checkNotNullExpressionValue((Object)factory3, (String)"factory.varFactory");
            DfaVariableValue.Factory varFactory = factory3;
            if (expr instanceof KtSimpleNameExpression) {
                DeclarationDescriptor descriptor2;
                PsiElement target2 = ResolutionUtils.resolveMainReference((KtReferenceExpression)expr);
                if (target2 instanceof KtCallableDeclaration) {
                    if (target2 instanceof KtParameter && !(((KtParameter)target2).getOwnerFunction() instanceof KtPrimaryConstructor) || target2 instanceof KtProperty && ((KtProperty)target2).isLocal() || target2 instanceof KtDestructuringDeclarationEntry) {
                        return varFactory.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)target2));
                    }
                    if (this.isTrackableProperty(target2)) {
                        PsiElement parent2 = ((KtSimpleNameExpression)expr).getParent();
                        DfaVariableValue qualifier2 = null;
                        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(KtClassBody.class)};
                        if (CollectionUtilsKt.match((Sequence<? extends Object>)PsiUtilsKt.getParents((PsiElement)target2), kClassArray, Reflection.getOrCreateKotlinClass(KtObjectDeclaration.class)) != null) {
                            return varFactory.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)target2), null);
                        }
                        if (parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getSelectorExpression(), (Object)expr)) {
                            KtExpression receiver2 = ((KtQualifiedExpression)parent2).getReceiverExpression();
                            qualifier2 = this.createFromSimpleName(factory2, receiver2);
                        } else {
                            ClassDescriptor classOrObject;
                            if (((KtCallableDeclaration)target2).getParent() instanceof KtFile) {
                                return varFactory.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)target2), null);
                            }
                            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)target2));
                            ClassDescriptor classDescriptor = classOrObject = ktClassOrObject != null ? ResolutionUtils.resolveToDescriptorIfAny$default(ktClassOrObject, null, 1, null) : null;
                            if (classOrObject != null) {
                                DfType dfType = KtDfaHelpersKt.toDfType((KotlinType)classOrObject.getDefaultType());
                                qualifier2 = varFactory.createVariableValue((VariableDescriptor)new KtThisDescriptor((DeclarationDescriptor)classOrObject, dfType));
                            }
                        }
                        if (qualifier2 != null) {
                            return varFactory.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)target2), qualifier2);
                        }
                    }
                }
                if (((KtSimpleNameExpression)expr).textMatches((CharSequence)"it") && (descriptor2 = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)expr))) instanceof ValueParameterDescriptor) {
                    KtElement fn;
                    SourceElement sourceElement = ModuleVisibilityUtilsKt.getToSourceElement((DeclarationDescriptor)((DeclarationDescriptor)((ValueParameterDescriptor)descriptor2).getContainingDeclaration()));
                    KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
                    Object object = fn = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
                    if (fn instanceof KtFunctionLiteral) {
                        KotlinType kotlinType = ((ValueParameterDescriptor)descriptor2).getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
                        KotlinType type2 = kotlinType;
                        return varFactory.createVariableValue((VariableDescriptor)new KtLambdaSpecialVariableDescriptor((KtFunctionLiteral)fn, LambdaVariableKind.IT, type2));
                    }
                }
            }
            return null;
        }

        private final boolean isTrackableProperty(PsiElement target2) {
            return target2 instanceof KtParameter && ((KtParameter)target2).getOwnerFunction() instanceof KtPrimaryConstructor || target2 instanceof KtProperty && !((KtProperty)target2).hasDelegate() && ((KtProperty)target2).getGetter() == null && ((KtProperty)target2).getSetter() == null && !PsiModificationUtilsKt.isOverridable((KtProperty)target2) && !KtPsiUtilKt.isExtensionDeclaration((PsiElement)target2) && ModifierListModifactorKt.findAnnotation((KtAnnotated)target2, JvmAnnotationUtilKt.VOLATILE_ANNOTATION_FQ_NAME) == null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

