/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.LoopToCallChainIntention;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.LoopToLazyCallChainIntention;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.MatchAndConvertKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.MatchResult;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/LoopToCallChainInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Fix", "kotlin.idea"})
public final class LoopToCallChainInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            @NotNull
            private final LoopToCallChainIntention nonLazyIntention;
            @NotNull
            private final LoopToLazyCallChainIntention lazyIntention;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                this.nonLazyIntention = new LoopToCallChainIntention();
                this.lazyIntention = new LoopToLazyCallChainIntention();
            }

            @NotNull
            public final LoopToCallChainIntention getNonLazyIntention() {
                return this.nonLazyIntention;
            }

            @NotNull
            public final LoopToLazyCallChainIntention getLazyIntention() {
                return this.lazyIntention;
            }

            public void visitForExpression(@NotNull KtForExpression expression2) {
                boolean lazyApplicable;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitForExpression(expression2);
                boolean nonLazyApplicable = this.nonLazyIntention.applicabilityRange(expression2) != null;
                boolean bl = lazyApplicable = this.lazyIntention.applicabilityRange(expression2) != null;
                if (!nonLazyApplicable && !lazyApplicable) {
                    return;
                }
                List fixes2 = new ArrayList<E>();
                if (nonLazyApplicable) {
                    ((Collection)fixes2).add(new Fix(false, this.nonLazyIntention.getText()));
                }
                if (lazyApplicable) {
                    ((Collection)fixes2).add(new Fix(true, this.lazyIntention.getText()));
                }
                Collection $this$toTypedArray$iv = fixes2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Fix[] fixArray = thisCollection$iv.toArray(new Fix[0]);
                this.$holder.registerProblem(expression2.getForKeyword(), KotlinBundle.message("loop.can.be.replaced.with.stdlib.operations", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(fixArray, fixArray.length));
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/LoopToCallChainInspection$Fix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "lazy", "", "text", "", "(ZLjava/lang/String;)V", "getLazy", "()Z", "getText", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFamilyName", "getName", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nLoopToCallChainInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoopToCallChainInspection.kt\norg/jetbrains/kotlin/idea/intentions/loopToCallChain/LoopToCallChainInspection$Fix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,137:1\n125#2:138\n*S KotlinDebug\n*F\n+ 1 LoopToCallChainInspection.kt\norg/jetbrains/kotlin/idea/intentions/loopToCallChain/LoopToCallChainInspection$Fix\n*L\n65#1:138\n*E\n"})
    public static final class Fix
    implements LocalQuickFix {
        private final boolean lazy;
        @NotNull
        private final String text;

        public Fix(boolean lazy, @Nls @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.lazy = lazy;
            this.text = text2;
        }

        public /* synthetic */ Fix(boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            this(bl, string2);
        }

        public final boolean getLazy() {
            return this.lazy;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public String getFamilyName() {
            return this.lazy ? KotlinBundle.message("loop.to.call.fix.family.name2", new Object[0]) : KotlinBundle.message("loop.to.call.fix.family.name", new Object[0]);
        }

        @NotNull
        public String getName() {
            return this.text;
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            void $this$getParentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
            PsiElement psiElement3 = psiElement2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtForExpression ktForExpression = (KtForExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtForExpression.class, (boolean)strict$iv);
            if (ktForExpression == null) {
                return;
            }
            KtForExpression expression2 = ktForExpression;
            Fix.applyFix$default(this, expression2, null, 2, null);
        }

        public final void applyFix(@NotNull KtForExpression expression2, @Nullable Editor editor2) {
            block3: {
                int n;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                MatchResult matchResult2 = MatchAndConvertKt.match(expression2, this.lazy, true);
                if (matchResult2 == null) {
                    return;
                }
                MatchResult match2 = matchResult2;
                KtExpression result2 = MatchAndConvertKt.convertLoop(expression2, match2);
                if (result2 instanceof KtProperty) {
                    PsiElement psiElement2 = ((KtProperty)result2).getNameIdentifier();
                    n = psiElement2 != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement2) : PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)result2));
                } else {
                    n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)result2));
                }
                int offset2 = n;
                Editor editor3 = editor2;
                if (editor3 == null) break block3;
                GenerateUtilsKt.moveCaret$default(editor3, offset2, null, 2, null);
            }
        }

        public static /* synthetic */ void applyFix$default(Fix fix3, KtForExpression ktForExpression, Editor editor2, int n, Object object) {
            if ((n & 2) != 0) {
                editor2 = EditorUtilsKt.findExistingEditor((PsiElement)ktForExpression);
            }
            fix3.applyFix(ktForExpression, editor2);
        }
    }
}

