/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing.inference.common;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundType;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundTypeLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.ClassReference;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.Constraint;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.ConstraintBound;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.DebugPrinter$addTypeVariablesNames$;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.DescriptorClassReference;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.EqualsConstraint;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.GenericLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.InferenceContext;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.LiteralBound;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.LiteralLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.Namer;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.NoClassReference;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.NullLiteralLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.StarProjectionLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.State;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.SubtypeConstraint;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeParameter;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeParameterLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeParameterReference;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariable;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariableBound;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariableLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.WithForcedStateBoundType;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\f\u001a\u00020\r*\u00020\u000eJ\n\u0010\u000f\u001a\u00020\b*\u00020\u0010J\n\u0010\u000f\u001a\u00020\b*\u00020\u0011J\f\u0010\u000f\u001a\u00020\b*\u00020\u0012H\u0002J\n\u0010\u000f\u001a\u00020\b*\u00020\u0013J\f\u0010\u000f\u001a\u00020\b*\u00020\u0014H\u0002J\n\u0010\u000f\u001a\u00020\b*\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/DebugPrinter;", "", "inferenceContext", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/InferenceContext;", "(Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/InferenceContext;)V", "namer", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/Namer;", "name", "", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/TypeVariable;", "getName", "(Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/TypeVariable;)Ljava/lang/String;", "addTypeVariablesNames", "", "Lcom/intellij/psi/PsiElement;", "asString", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundType;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundTypeLabel;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/ClassReference;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/Constraint;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/ConstraintBound;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/State;", "kotlin.j2k.post-processing"})
@SourceDebugExtension(value={"SMAP\nDebugPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugPrinter.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/DebugPrinter\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,78:1\n286#2,15:79\n228#2,2:94\n240#2:96\n305#2:97\n*S KotlinDebug\n*F\n+ 1 DebugPrinter.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/DebugPrinter\n*L\n62#1:79,15\n62#1:94,2\n62#1:96\n62#1:97\n*E\n"})
public final class DebugPrinter {
    @NotNull
    private final InferenceContext inferenceContext;
    @NotNull
    private final Namer namer;

    public DebugPrinter(@NotNull InferenceContext inferenceContext2) {
        Intrinsics.checkNotNullParameter((Object)inferenceContext2, (String)"inferenceContext");
        this.inferenceContext = inferenceContext2;
        this.namer = new Namer(this.inferenceContext);
    }

    @NotNull
    public final String getName(@NotNull TypeVariable $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        return this.namer.name($this$name);
    }

    private final String asString(ClassReference $this$asString) {
        String string2;
        ClassReference classReference2 = $this$asString;
        if (classReference2 instanceof DescriptorClassReference) {
            string2 = ((DescriptorClassReference)$this$asString).getDescriptor().getName().toString();
        } else if (classReference2 instanceof TypeParameterReference) {
            string2 = ((TypeParameterReference)$this$asString).getDescriptor().getName().toString();
        } else if (classReference2 instanceof NoClassReference) {
            string2 = "NoClassRef";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"when (this) {\n        is\u2026nce -> \"NoClassRef\"\n    }");
        return string3;
    }

    @NotNull
    public final String asString(@NotNull BoundTypeLabel $this$asString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        BoundTypeLabel boundTypeLabel = $this$asString;
        if (boundTypeLabel instanceof TypeVariableLabel) {
            object = this.getName(((TypeVariableLabel)$this$asString).getTypeVariable()) + "@" + this.asString(((TypeVariableLabel)$this$asString).getTypeVariable().getClassReference());
        } else if (boundTypeLabel instanceof TypeParameterLabel) {
            String string2 = ((TypeParameterLabel)$this$asString).getTypeParameter().getName().asString();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeParameter.name.asString()");
        } else if (boundTypeLabel instanceof GenericLabel) {
            object = this.asString(((GenericLabel)$this$asString).getClassReference());
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)StarProjectionLabel.INSTANCE)) {
            object = "*";
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)NullLiteralLabel.INSTANCE)) {
            object = "NULL";
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)LiteralLabel.INSTANCE)) {
            object = "LIT";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final String asString(@NotNull State $this$asString) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$asString), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$asString.ordinal()]) {
            case 1 -> "L";
            case 2 -> "U";
            case 3 -> "?";
            case 4 -> "$";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String asString(@NotNull BoundType $this$asString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        StringBuilder $this$asString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$asString_u24lambda_u240.append(this.asString($this$asString.getLabel()));
        if (!((Collection)$this$asString.getTypeParameters()).isEmpty()) {
            CollectionsKt.joinTo$default((Iterable)$this$asString.getTypeParameters(), (Appendable)$this$asString_u24lambda_u240, (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<TypeParameter, CharSequence>(this){
                final /* synthetic */ DebugPrinter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull TypeParameter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.asString(it.getBoundType());
                }
            }), (int)48, null);
        }
        if ($this$asString instanceof WithForcedStateBoundType) {
            $this$asString_u24lambda_u240.append("!!");
            $this$asString_u24lambda_u240.append(this.asString(((WithForcedStateBoundType)$this$asString).getForcedState()));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final String asString(@NotNull Constraint $this$asString) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        Constraint constraint = $this$asString;
        if (constraint instanceof EqualsConstraint) {
            string2 = this.asString(((EqualsConstraint)$this$asString).getLeft()) + " := " + this.asString(((EqualsConstraint)$this$asString).getRight());
        } else if (constraint instanceof SubtypeConstraint) {
            string2 = this.asString(((SubtypeConstraint)$this$asString).getSubtype()) + " <: " + this.asString(((SubtypeConstraint)$this$asString).getSupertype());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2 + " due to '" + $this$asString.getPriority() + "'";
    }

    private final String asString(ConstraintBound $this$asString) {
        String string2;
        ConstraintBound constraintBound = $this$asString;
        if (constraintBound instanceof LiteralBound) {
            string2 = ((LiteralBound)$this$asString).getState().toString();
        } else if (constraintBound instanceof TypeVariableBound) {
            string2 = this.getName(((TypeVariableBound)$this$asString).getTypeVariable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTypeVariablesNames(@NotNull PsiElement $this$addTypeVariablesNames) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addTypeVariablesNames, (String)"<this>");
        Project project2 = $this$addTypeVariablesNames.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        PsiElement $this$collectDescendantsOfType_u24default$iv = $this$addTypeVariablesNames;
        Function1 predicate$iv = addTypeVariablesNames$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement psiElement2 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var12_12 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtTypeElement, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
                if (element3 instanceof KtTypeElement) {
                    this.$action.invoke((Object)element3);
                }
            }
        });
        for (KtTypeElement typeElement2 : (List)to$iv$iv$iv) {
            Object object = this.inferenceContext.getTypeElementToTypeVariable().get(typeElement2);
            if (object == null || (object = this.getName((TypeVariable)object)) == null) continue;
            Object typeVariableName = object;
            PsiComment comment2 = psiFactory.createComment("/*" + (String)typeVariableName + "@*/");
            typeElement2.getParent().addBefore((PsiElement)comment2, (PsiElement)typeElement2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.LOWER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.UPPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.UNUSED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

