/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "typeParameter", "upperBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lorg/jetbrains/kotlin/types/KotlinType;)V", "renderedUpperBound", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Factory", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddGenericUpperBoundFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddGenericUpperBoundFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class AddGenericUpperBoundFix
extends KotlinQuickFixAction<KtTypeParameter> {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final String renderedUpperBound;

    public AddGenericUpperBoundFix(@NotNull KtTypeParameter typeParameter2, @NotNull KotlinType upperBound) {
        Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
        Intrinsics.checkNotNullParameter((Object)upperBound, (String)"upperBound");
        super((PsiElement)typeParameter2);
        this.renderedUpperBound = IdeDescriptorRenderers.SOURCE_CODE.renderType(upperBound);
    }

    @NotNull
    public String getText() {
        String string2;
        String string3;
        KtTypeParameter element3 = (KtTypeParameter)this.getElement();
        if (element3 != null) {
            Object[] objectArray = new Object[]{this.renderedUpperBound, String.valueOf(element3.getName())};
            string3 = KotlinBundle.message("fix.add.generic.upperbound.text", objectArray);
        } else {
            string3 = string2 = null;
        }
        if (string3 == null) {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.add.generic.upperbound.family", new Object[0]);
    }

    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtTypeParameter ktTypeParameter = (KtTypeParameter)this.getElement();
        if (ktTypeParameter == null) {
            return false;
        }
        KtTypeParameter element3 = ktTypeParameter;
        return element3.getName() != null && element3.getExtendsBound() == null;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtTypeParameter ktTypeParameter = (KtTypeParameter)this.getElement();
        if (ktTypeParameter == null) {
            return;
        }
        KtTypeParameter element3 = ktTypeParameter;
        boolean bl2 = bl = element3.getExtendsBound() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-AddGenericUpperBoundFix$invoke$22 = false;
            String $i$a$-assert-AddGenericUpperBoundFix$invoke$22 = "Don't know what to do with existing bounds";
            throw new AssertionError((Object)$i$a$-assert-AddGenericUpperBoundFix$invoke$22);
        }
        KtTypeReference typeReference2 = new KtPsiFactory(project2, false, 2, null).createType(this.renderedUpperBound);
        KtTypeReference ktTypeReference = element3.setExtendsBound(typeReference2);
        Intrinsics.checkNotNull((Object)ktTypeReference);
        KtTypeReference insertedTypeReference = ktTypeReference;
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)insertedTypeReference, null, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "argument", "Lorg/jetbrains/kotlin/types/KotlinType;", "upperBound", "createActionsByInferenceData", "", "inferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "doCreateActions", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAddGenericUpperBoundFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddGenericUpperBoundFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix$Factory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1603#2,9:111\n1855#2:120\n1856#2:122\n1612#2:123\n1#3:121\n*S KotlinDebug\n*F\n+ 1 AddGenericUpperBoundFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix$Factory\n*L\n83#1:111,9\n83#1:120\n83#1:122\n83#1:123\n83#1:121\n*E\n"})
    public static final class Factory
    extends KotlinIntentionActionsFactory {
        private Factory() {
        }

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.UPPER_BOUND_VIOLATED)) {
                DiagnosticWithParameters2 upperBoundViolated = (DiagnosticWithParameters2)Errors.UPPER_BOUND_VIOLATED.cast((UnboundDiagnostic)diagnostic);
                Object object = upperBoundViolated.getB();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"upperBoundViolated.b");
                KotlinType kotlinType = (KotlinType)object;
                Object object2 = upperBoundViolated.getA();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"upperBoundViolated.a");
                list2 = CollectionsKt.listOfNotNull((Object)this.createAction(kotlinType, (KotlinType)object2));
            } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED)) {
                Object object = ((DiagnosticWithParameters1)Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.cast((UnboundDiagnostic)diagnostic)).getA();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"TYPE_INFERENCE_UPPER_BOU\u2026OLATED.cast(diagnostic).a");
                InferenceErrorData inferenceData = (InferenceErrorData)object;
                list2 = this.createActionsByInferenceData(inferenceData);
            } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)ErrorsJvm.UPPER_BOUND_VIOLATED_BASED_ON_JAVA_ANNOTATIONS)) {
                DiagnosticWithParameters2 upperBoundViolated = (DiagnosticWithParameters2)ErrorsJvm.UPPER_BOUND_VIOLATED_BASED_ON_JAVA_ANNOTATIONS.cast((UnboundDiagnostic)diagnostic);
                Object object = upperBoundViolated.getB();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"upperBoundViolated.b");
                KotlinType kotlinType = (KotlinType)object;
                Object object3 = upperBoundViolated.getA();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"upperBoundViolated.a");
                list2 = CollectionsKt.listOfNotNull((Object)this.createAction(kotlinType, (KotlinType)object3));
            } else {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IntentionAction> createActionsByInferenceData(InferenceErrorData inferenceData) {
            void $this$mapNotNullTo$iv$iv;
            ConstraintSystem constraintSystem = inferenceData.constraintSystem;
            Intrinsics.checkNotNullExpressionValue((Object)constraintSystem, (String)"inferenceData.constraintSystem");
            ConstraintSystem successfulConstraintSystem = ConstraintSystemUtilsKt.filterConstraintsOut((ConstraintSystem)constraintSystem, (ConstraintPositionKind)ConstraintPositionKind.TYPE_BOUND_POSITION);
            if (!successfulConstraintSystem.getStatus().isSuccessful()) {
                return CollectionsKt.emptyList();
            }
            TypeSubstitutor resultingSubstitutor2 = successfulConstraintSystem.getResultingSubstitutor();
            List list2 = inferenceData.descriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"inferenceData.descriptor.typeParameters");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IntentionAction intentionAction;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)element$iv$iv;
                boolean bl2 = false;
                if (ConstraintsUtil.checkUpperBoundIsSatisfied((ConstraintSystem)successfulConstraintSystem, (TypeParameterDescriptor)typeParameterDescriptor, (Call)inferenceData.call, (boolean)true)) {
                    intentionAction = null;
                } else {
                    List list3 = typeParameterDescriptor.getUpperBounds();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"typeParameterDescriptor.upperBounds");
                    if ((KotlinType)CollectionsKt.singleOrNull((List)list3) == null) {
                        intentionAction = null;
                    } else if (resultingSubstitutor2.substitute((KotlinType)typeParameterDescriptor.getDefaultType(), Variance.INVARIANT) == null) {
                        intentionAction = null;
                    } else {
                        KotlinType upperBound;
                        KotlinType argument2;
                        Intrinsics.checkNotNullExpressionValue((Object)argument2, (String)"resultingSubstitutor.sub\u2026   ?: return@factory null");
                        intentionAction = Factory.createAction(argument2, upperBound);
                    }
                }
                if (intentionAction == null) continue;
                IntentionAction it$iv$iv = intentionAction;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final IntentionAction createAction(KotlinType argument2, KotlinType upperBound) {
            if (!upperBound.getConstructor().isDenotable()) {
                return null;
            }
            ClassifierDescriptor classifierDescriptor = argument2.getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
            if (typeParameterDescriptor == null) {
                return null;
            }
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            PsiElement psiElement2 = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)((DeclarationDescriptor)typeParameterDescriptor2));
            KtTypeParameter ktTypeParameter = psiElement2 instanceof KtTypeParameter ? (KtTypeParameter)psiElement2 : null;
            if (ktTypeParameter == null) {
                return null;
            }
            KtTypeParameter typeParameterDeclaration = ktTypeParameter;
            return new AddGenericUpperBoundFix(typeParameterDeclaration, upperBound);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

