/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.memberInfo;

import com.intellij.icons.AllIcons;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.ui.RowIcon;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIconProvider;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0003H\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\u0003H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberSelectionTable;", "Lcom/intellij/refactoring/ui/AbstractMemberSelectionTable;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "memberInfos", "", "memberInfoModel", "Lcom/intellij/refactoring/classMembers/MemberInfoModel;", "abstractColumnHeader", "", "(Ljava/util/List;Lcom/intellij/refactoring/classMembers/MemberInfoModel;Ljava/lang/String;)V", "getAbstractColumnValue", "", "memberInfo", "getOverrideIcon", "Ljavax/swing/Icon;", "isAbstractColumnEditable", "", "rowIndex", "", "setVisibilityIcon", "", "icon", "Lcom/intellij/ui/RowIcon;", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKotlinMemberSelectionTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMemberSelectionTable.kt\norg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberSelectionTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class KotlinMemberSelectionTable
extends AbstractMemberSelectionTable<KtNamedDeclaration, KotlinMemberInfo> {
    public KotlinMemberSelectionTable(@NotNull List<KotlinMemberInfo> memberInfos, @Nullable MemberInfoModel<KtNamedDeclaration, KotlinMemberInfo> memberInfoModel, @Nls @Nullable String abstractColumnHeader) {
        Intrinsics.checkNotNullParameter(memberInfos, (String)"memberInfos");
        super((Collection)memberInfos, memberInfoModel, abstractColumnHeader);
    }

    @Nullable
    protected Object getAbstractColumnValue(@NotNull KotlinMemberInfo memberInfo) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)memberInfo), (String)"memberInfo");
        if (memberInfo.isStatic() || memberInfo.isCompanionMember()) {
            return null;
        }
        KtNamedDeclaration member2 = (KtNamedDeclaration)memberInfo.getMember();
        if (!(member2 instanceof KtNamedFunction || member2 instanceof KtProperty || member2 instanceof KtParameter)) {
            return null;
        }
        if (member2.hasModifier(KtTokens.ABSTRACT_KEYWORD) && (bl = this.myMemberInfoModel.isFixedAbstract((MemberInfoBase)memberInfo)) != null) {
            boolean it = bl;
            boolean bl2 = false;
            return it;
        }
        if (this.myMemberInfoModel.isAbstractEnabled((MemberInfoBase)memberInfo)) {
            return memberInfo.isToAbstract();
        }
        return this.myMemberInfoModel.isAbstractWhenDisabled((MemberInfoBase)memberInfo);
    }

    protected boolean isAbstractColumnEditable(int rowIndex) {
        Boolean bl;
        KotlinMemberInfo memberInfo = (KotlinMemberInfo)((Object)this.myMemberInfos.get(rowIndex));
        if (memberInfo.isStatic()) {
            return false;
        }
        KtNamedDeclaration member2 = (KtNamedDeclaration)memberInfo.getMember();
        if (!(member2 instanceof KtNamedFunction || member2 instanceof KtProperty || member2 instanceof KtParameter)) {
            return false;
        }
        if (member2.hasModifier(KtTokens.ABSTRACT_KEYWORD) && (bl = this.myMemberInfoModel.isFixedAbstract((MemberInfoBase)memberInfo)) != null) {
            boolean it = bl;
            boolean bl2 = false;
            return false;
        }
        return memberInfo.isChecked() && this.myMemberInfoModel.isAbstractEnabled((MemberInfoBase)memberInfo);
    }

    protected void setVisibilityIcon(@NotNull KotlinMemberInfo memberInfo, @NotNull RowIcon icon) {
        Intrinsics.checkNotNullParameter((Object)((Object)memberInfo), (String)"memberInfo");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        icon.setIcon(KotlinIconProvider.Companion.getVisibilityIcon(((KtNamedDeclaration)memberInfo.getMember()).getModifierList()), 1);
    }

    @Nullable
    protected Icon getOverrideIcon(@NotNull KotlinMemberInfo memberInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)memberInfo), (String)"memberInfo");
        Icon defaultIcon = AbstractMemberSelectionTable.EMPTY_OVERRIDE_ICON;
        KtNamedDeclaration member2 = (KtNamedDeclaration)memberInfo.getMember();
        if (!(member2 instanceof KtNamedFunction || member2 instanceof KtProperty || member2 instanceof KtParameter)) {
            return defaultIcon;
        }
        Boolean bl = memberInfo.getOverrides();
        return Intrinsics.areEqual((Object)bl, (Object)true) ? AllIcons.General.OverridingMethod : (Intrinsics.areEqual((Object)bl, (Object)false) ? AllIcons.General.ImplementingMethod : defaultIcon);
    }
}

