/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.changePackage;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveDeclarationDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSource;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSourceKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.MoveContainerChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveContainerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/KotlinChangePackageRefactoring;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "run", "", "newFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.idea"})
public final class KotlinChangePackageRefactoring {
    @NotNull
    private final KtFile file;
    @NotNull
    private final Project project;

    public KotlinChangePackageRefactoring(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.file = file2;
        Project project2 = this.file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        this.project = project2;
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    public final void run(@NotNull FqName newFqName) {
        Intrinsics.checkNotNullParameter((Object)newFqName, (String)"newFqName");
        KtPackageDirective ktPackageDirective = this.file.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        FqName fqName2 = packageDirective.getFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"packageDirective.fqName");
        FqName currentFqName = fqName2;
        KotlinMoveSource kotlinMoveSource = KotlinMoveSourceKt.KotlinMoveSource(this.file);
        PsiDirectory psiDirectory = this.file.getContainingDirectory();
        Intrinsics.checkNotNull((Object)psiDirectory);
        VirtualFile virtualFile2 = psiDirectory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.containingDirectory!!.virtualFile");
        MoveKotlinDeclarationsProcessor declarationProcessor = new MoveKotlinDeclarationsProcessor(new MoveDeclarationsDescriptor(this.project, kotlinMoveSource, new KotlinMoveTarget.Directory(newFqName, virtualFile2), KotlinMoveDeclarationDelegate.TopLevel.INSTANCE, KotlinRefactoringSettings.Companion.getInstance().MOVE_SEARCH_IN_COMMENTS, KotlinRefactoringSettings.Companion.getInstance().MOVE_SEARCH_FOR_TEXT, false, null, false, null, false, false, 4032, null), null, false, 6, null);
        String string2 = RefactoringBundle.message((String)"progress.text");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"progress.text\")");
        List list2 = (List)ProgressUtilsKt.runSynchronouslyWithProgress(this.project, string2, true, (Function0)new Function0<List<? extends UsageInfo>>(declarationProcessor){
            final /* synthetic */ MoveKotlinDeclarationsProcessor $declarationProcessor;
            {
                this.$declarationProcessor = $declarationProcessor;
                super(0);
            }

            @NotNull
            public final List<UsageInfo> invoke() {
                return (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends UsageInfo>>(this.$declarationProcessor){
                    final /* synthetic */ MoveKotlinDeclarationsProcessor $declarationProcessor;
                    {
                        this.$declarationProcessor = $declarationProcessor;
                        super(0);
                    }

                    @NotNull
                    public final List<UsageInfo> invoke() {
                        return ArraysKt.toList((Object[])this.$declarationProcessor.findUsages());
                    }
                }));
            }
        });
        if (list2 == null) {
            return;
        }
        List declarationUsages2 = list2;
        MoveContainerChangeInfo changeInfo = new MoveContainerChangeInfo(new MoveContainerInfo.Package(currentFqName), new MoveContainerInfo.Package(newFqName));
        List<UsageInfo> internalUsages = MoveUtilKt.getInternalReferencesToUpdateOnPackageNameChange((KtElement)this.file, changeInfo);
        Object[] objectArray = new Object[]{newFqName};
        ApplicationUtilsKt.executeWriteCommand(this.project, KotlinBundle.message("text.change.file.package.to.0", objectArray), (Function0<Unit>)((Function0)new Function0<Unit>(packageDirective, newFqName, internalUsages, this, declarationProcessor, (List<? extends UsageInfo>)declarationUsages2){
            final /* synthetic */ KtPackageDirective $packageDirective;
            final /* synthetic */ FqName $newFqName;
            final /* synthetic */ List<UsageInfo> $internalUsages;
            final /* synthetic */ KotlinChangePackageRefactoring this$0;
            final /* synthetic */ MoveKotlinDeclarationsProcessor $declarationProcessor;
            final /* synthetic */ List<UsageInfo> $declarationUsages;
            {
                this.$packageDirective = $packageDirective;
                this.$newFqName = $newFqName;
                this.$internalUsages = $internalUsages;
                this.this$0 = $receiver;
                this.$declarationProcessor = $declarationProcessor;
                this.$declarationUsages = $declarationUsages;
                super(0);
            }

            public final void invoke() {
                this.$packageDirective.setFqName(FqNameUtils.quoteIfNeeded(this.$newFqName));
                MoveUtilKt.postProcessMoveUsages$default(this.$internalUsages, null, null, 6, null);
                DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests(KotlinChangePackageRefactoring.access$getProject$p(this.this$0));
                this.$declarationProcessor.execute(this.$declarationUsages);
            }
        }));
    }

    public static final /* synthetic */ Project access$getProject$p(KotlinChangePackageRefactoring $this) {
        return $this.project;
    }
}

