/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/InlayScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "toolWindowHandler", "(Lcom/intellij/openapi/fileEditor/TextEditor;Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;)V", "maxInsertOffset", "", "maxLineLength", "minSpaceCount", "clear", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "clearInlays", "editor", "createInlay", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "error", "message", "", "handle", "onFinish", "onStart", "printToToolWindow", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nInlayScratchOutputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/scratch/output/InlayScratchOutputHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1360#2:109\n1446#2,5:110\n661#2,11:116\n766#2:127\n857#2,2:128\n1855#2,2:130\n1#3:115\n*S KotlinDebug\n*F\n+ 1 InlayScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/scratch/output/InlayScratchOutputHandler\n*L\n95#1:109\n95#1:110,5\n76#1:116,11\n103#1:127\n103#1:128,2\n104#1:130,2\n*E\n"})
public final class InlayScratchOutputHandler
implements ScratchOutputHandler {
    @NotNull
    private final TextEditor textEditor;
    @NotNull
    private final ScratchOutputHandler toolWindowHandler;
    private final int maxLineLength;
    private final int maxInsertOffset;
    private final int minSpaceCount;

    public InlayScratchOutputHandler(@NotNull TextEditor textEditor, @NotNull ScratchOutputHandler toolWindowHandler) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)toolWindowHandler, (String)"toolWindowHandler");
        this.textEditor = textEditor;
        this.toolWindowHandler = toolWindowHandler;
        this.maxLineLength = 120;
        this.maxInsertOffset = 60;
        this.minSpaceCount = 4;
    }

    @Override
    public void onStart(@NotNull ScratchFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.toolWindowHandler.onStart(file2);
    }

    @Override
    public void handle(@NotNull ScratchFile file2, @NotNull ScratchExpression expression2, @NotNull ScratchOutput output) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (StringsKt.isBlank((CharSequence)output.getText())) {
            return;
        }
        this.createInlay(file2, expression2, output);
        if (output.getType() == ScratchOutputType.ERROR) {
            this.toolWindowHandler.handle(file2, expression2, output);
        }
    }

    @Override
    public void error(@NotNull ScratchFile file2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.toolWindowHandler.error(file2, message2);
    }

    @Override
    public void onFinish(@NotNull ScratchFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.toolWindowHandler.onFinish(file2);
    }

    @Override
    public void clear(@NotNull ScratchFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.clearInlays(this.textEditor);
        this.toolWindowHandler.clear(file2);
    }

    private final void createInlay(ScratchFile file2, ScratchExpression expression2, ScratchOutput output) {
        TransactionGuard.submitTransaction((Disposable)KotlinPluginDisposable.Companion.getInstance(file2.getProject()), () -> InlayScratchOutputHandler.createInlay$lambda$2(this, expression2, file2, output));
    }

    private final void printToToolWindow(ScratchFile file2, ScratchExpression expression2, ScratchOutput output) {
        if (output.getType() != ScratchOutputType.ERROR) {
            this.toolWindowHandler.handle(file2, expression2, output);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int maxLineLength(ScratchFile file2) {
        Comparable comparable;
        void $this$flatMapTo$iv$iv;
        Document document = this.textEditor.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"textEditor.editor.document");
        Document doc = document;
        Iterable $this$flatMap$iv = file2.getExpressions();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ScratchExpression it = (ScratchExpression)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)new IntRange(it.getLineStart(), it.getLineEnd());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterator iterator2 = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            int it = ((Number)iterator2.next()).intValue();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(doc.getLineEndOffset(it) - doc.getLineStartOffset(it));
            while (iterator2.hasNext()) {
                int it2 = ((Number)iterator2.next()).intValue();
                $i$a$-maxOfOrNull-InlayScratchOutputHandler$maxLineLength$2 = false;
                Comparable comparable3 = Integer.valueOf(doc.getLineEndOffset(it2) - doc.getLineStartOffset(it2));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    private final void clearInlays(TextEditor editor2) {
        TransactionGuard.submitTransaction((Disposable)((Disposable)editor2), () -> InlayScratchOutputHandler.clearInlays$lambda$7(editor2));
    }

    private static final void createInlay$lambda$2$addInlay(InlayScratchOutputHandler this$0, Ref.IntRef spaceCount, int lineLength, ScratchFile $file, ScratchExpression $expression, ScratchOutput $output, Editor editor2, int lineEndOffset, String text2) {
        String textBeforeNewLine = StringUtil.containsLineBreak((CharSequence)text2) ? StringsKt.substringBefore$default((String)text2, (String)"\n", null, (int)2, null) + "..." : text2;
        Integer n = this$0.maxLineLength - spaceCount.element - lineLength;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 5 ? n : null;
        int maxInlayLength = n2 != null ? n2 : 5;
        String string2 = StringUtil.shortenTextWithEllipsis((String)textBeforeNewLine, (int)maxInlayLength, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"shortenTextWithEllipsis(\u2026wLine, maxInlayLength, 0)");
        String shortText = string2;
        if (!Intrinsics.areEqual((Object)shortText, (Object)text2)) {
            this$0.printToToolWindow($file, $expression, $output);
        }
        editor2.getInlayModel().addAfterLineEndElement(lineEndOffset, false, (EditorCustomElementRenderer)new InlayScratchFileRenderer(StringsKt.repeat((CharSequence)" ", (int)spaceCount.element) + shortText, $output.getType()));
    }

    /*
     * WARNING - void declaration
     */
    private static final void createInlay$lambda$2(InlayScratchOutputHandler this$0, ScratchExpression $expression, ScratchFile $file, ScratchOutput $output) {
        Object v2;
        Ref.IntRef spaceCount;
        int lineLength;
        int lineEndOffset;
        Editor editor2;
        block5: {
            void $this$singleOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$expression, (String)"$expression");
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            Intrinsics.checkNotNullParameter((Object)$output, (String)"$output");
            Editor editor3 = this$0.textEditor.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"textEditor.editor");
            editor2 = editor3;
            int line = $expression.getLineStart();
            int lineStartOffset = editor2.getDocument().getLineStartOffset(line);
            lineEndOffset = editor2.getDocument().getLineEndOffset(line);
            lineLength = lineEndOffset - lineStartOffset;
            spaceCount = new Ref.IntRef();
            spaceCount.element = this$0.maxLineLength($file) - lineLength + this$0.minSpaceCount;
            while (spaceCount.element + lineLength > this$0.maxInsertOffset && spaceCount.element > this$0.minSpaceCount) {
                int n = spaceCount.element;
                spaceCount.element = n + -1;
            }
            List list2 = editor2.getInlayModel().getAfterLineEndElementsInRange(lineEndOffset, lineEndOffset);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.inlayModel\n      \u2026EndOffset, lineEndOffset)");
            Iterable iterable = list2;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Inlay it = (Inlay)element$iv;
                boolean bl = false;
                if (!(it.getRenderer() instanceof InlayScratchFileRenderer)) continue;
                if (found$iv) {
                    v2 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        Inlay existing = v2;
        if (existing != null) {
            existing.dispose();
            EditorCustomElementRenderer editorCustomElementRenderer = existing.getRenderer();
            Intrinsics.checkNotNull((Object)editorCustomElementRenderer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer");
            InlayScratchOutputHandler.createInlay$lambda$2$addInlay(this$0, spaceCount, lineLength, $file, $expression, $output, editor2, lineEndOffset, StringsKt.drop((String)(((InlayScratchFileRenderer)editorCustomElementRenderer).getText() + "; " + $output.getText()), (int)spaceCount.element));
        } else {
            InlayScratchOutputHandler.createInlay$lambda$2$addInlay(this$0, spaceCount, lineLength, $file, $expression, $output, editor2, lineEndOffset, $output.getText());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void clearInlays$lambda$7(TextEditor $editor) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        List list2 = $editor.getEditor().getInlayModel().getAfterLineEndElementsInRange(0, $editor.getEditor().getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.editor.inlayModel\u2026itor.document.textLength)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Inlay it = (Inlay)element$iv$iv;
            boolean bl = false;
            if (!(it.getRenderer() instanceof InlayScratchFileRenderer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it = (Inlay)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }
}

