/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.testIntegration.framework;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinPsiBasedTestFramework;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0004J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0004J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0004J\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0004J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u001cH\u0004J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\"H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/testIntegration/framework/AbstractKotlinPsiBasedTestFramework;", "Lorg/jetbrains/kotlin/idea/testIntegration/framework/KotlinPsiBasedTestFramework;", "()V", "allowTestMethodsInObject", "", "getAllowTestMethodsInObject", "()Z", "disabledTestAnnotation", "", "getDisabledTestAnnotation", "()Ljava/lang/String;", "markerClassFqn", "getMarkerClassFqn", "checkNameMatch", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "fqNames", "", "shortName", "findAnnotatedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isAnnotated", "element", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "fqName", "isFrameworkAvailable", "Lorg/jetbrains/kotlin/psi/KtElement;", "isIgnoredMethod", "declaration", "isTestClass", "isTestMethod", "responsibleFor", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "kotlin.base.code-insight"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinPsiBasedTestFramework.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinPsiBasedTestFramework.kt\norg/jetbrains/kotlin/idea/testIntegration/framework/AbstractKotlinPsiBasedTestFramework\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,121:1\n1#2:122\n1747#3,3:123\n1747#3,3:126\n142#4:129\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinPsiBasedTestFramework.kt\norg/jetbrains/kotlin/idea/testIntegration/framework/AbstractKotlinPsiBasedTestFramework\n*L\n39#1:123,3\n40#1:126,3\n54#1:129\n*E\n"})
public abstract class AbstractKotlinPsiBasedTestFramework
implements KotlinPsiBasedTestFramework {
    @NotNull
    protected abstract String getMarkerClassFqn();

    @NotNull
    protected abstract String getDisabledTestAnnotation();

    protected abstract boolean getAllowTestMethodsInObject();

    protected final boolean isFrameworkAvailable(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Module module2 = GenericPsiUtils.getModule((PsiElement)element3);
        if (module2 == null) {
            return false;
        }
        Module module3 = module2;
        return JavaLibraryUtil.hasLibraryClass((Module)module3, (String)this.getMarkerClassFqn());
    }

    @Override
    public boolean responsibleFor(@NotNull KtNamedDeclaration declaration2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!this.isFrameworkAvailable((KtElement)declaration2)) {
            return false;
        }
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtClassOrObject) {
            bl = this.isTestClass((KtClassOrObject)declaration2);
        } else if (ktNamedDeclaration instanceof KtNamedFunction) {
            boolean bl2;
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2));
            if (ktClassOrObject != null) {
                KtClassOrObject p0 = ktClassOrObject;
                boolean bl3 = false;
                bl2 = this.isTestClass(p0);
            } else {
                bl2 = false;
            }
            bl = bl2 && this.isTestMethod((KtNamedFunction)declaration2);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isTestClass(@NotNull KtClassOrObject declaration2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)declaration2))) {
            bl = false;
        } else if (declaration2.isAnnotation()) {
            bl = false;
        } else if (declaration2.isTopLevel() && declaration2 instanceof KtObjectDeclaration && !this.getAllowTestMethodsInObject()) {
            bl = false;
        } else {
            List list2 = declaration2.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"declaration.annotations");
            if (!((Collection)list2).isEmpty()) {
                bl = true;
            } else {
                KtSuperTypeListEntry it;
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block16: {
                    $this$any$iv = declaration2.getSuperTypeListEntries();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (KtSuperTypeListEntry)element$iv;
                            boolean bl3 = false;
                            if (!(it instanceof KtSuperTypeCallEntry)) continue;
                            bl2 = true;
                            break block16;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    bl = true;
                } else {
                    boolean bl4;
                    block17: {
                        $this$any$iv = declaration2.getDeclarations();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (KtDeclaration)element$iv;
                                boolean bl5 = false;
                                if (!(it instanceof KtNamedFunction && KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)it)))) continue;
                                bl4 = true;
                                break block17;
                            }
                            bl4 = false;
                        }
                    }
                    bl = bl4;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isTestMethod(@NotNull KtNamedFunction declaration2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2.isTopLevel()) {
            bl = false;
        } else if (declaration2.isLocal()) {
            bl = false;
        } else if (declaration2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            bl = false;
        } else if (declaration2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            bl = false;
        } else if (KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)declaration2))) {
            bl = false;
        } else {
            KtClassOrObject ktClassOrObject;
            KtClassOrObject ktClassOrObject2;
            if (this.getAllowTestMethodsInObject()) {
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)declaration2;
                boolean $i$f$getStrictParentOfType = false;
                ktClassOrObject2 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
            } else {
                ktClassOrObject2 = (KtClassOrObject)KtPsiUtilKt.containingClass((KtElement)((KtElement)declaration2));
            }
            KtClassOrObject ktClassOrObject3 = ktClassOrObject = ktClassOrObject2;
            if (ktClassOrObject3 != null) {
                KtClassOrObject p0 = ktClassOrObject3;
                boolean bl2 = false;
                bl = this.isTestClass(p0);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean isIgnoredMethod(@NotNull KtNamedFunction declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return (this.isAnnotated((KtAnnotated)declaration2, "kotlin.test.Ignore") || this.isAnnotated((KtAnnotated)declaration2, this.getDisabledTestAnnotation())) && this.isTestMethod(declaration2);
    }

    protected final boolean checkNameMatch(@NotNull KtFile file2, @NotNull Set<String> fqNames, @NotNull String shortName) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(fqNames, (String)"fqNames");
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        if (fqNames.contains(file2.getPackageFqName() + "." + shortName)) {
            return true;
        }
        for (KtImportDirective importDirective2 : file2.getImportDirectives()) {
            Object object;
            if (!importDirective2.isValidImport() || (object = importDirective2.getImportedFqName()) == null || (object = object.asString()) == null) continue;
            Object importedFqName = object;
            if (!importDirective2.isAllUnder()) {
                if (Intrinsics.areEqual((Object)importDirective2.getAliasName(), (Object)shortName) && fqNames.contains(importedFqName)) {
                    return true;
                }
                if (!fqNames.contains(importedFqName) || !StringsKt.endsWith$default((String)importedFqName, (String)("." + shortName), (boolean)false, (int)2, null)) continue;
                return true;
            }
            if (!fqNames.contains((String)importedFqName + "." + shortName)) continue;
            return true;
        }
        return false;
    }

    protected final boolean isAnnotated(@NotNull KtAnnotated element3, @NotNull String fqName2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.isAnnotated(element3, SetsKt.setOf((Object)fqName2));
    }

    protected final boolean isAnnotated(@NotNull KtAnnotated element3, @NotNull Set<String> fqNames) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(fqNames, (String)"fqNames");
        List list2 = element3.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.annotationEntries");
        List annotationEntries = list2;
        if (annotationEntries.isEmpty()) {
            return false;
        }
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        KtFile file2 = ktFile;
        for (KtAnnotationEntry annotationEntry2 : annotationEntries) {
            Name shortName;
            if (annotationEntry2.getShortName() == null) continue;
            String string2 = shortName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"shortName.asString()");
            if (!this.checkNameMatch(file2, fqNames, string2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected final KtNamedFunction findAnnotatedFunction(@Nullable KtClassOrObject classOrObject, @NotNull Set<String> fqNames) {
        Intrinsics.checkNotNullParameter(fqNames, (String)"fqNames");
        if (classOrObject == null) {
            return null;
        }
        for (KtDeclaration declaration2 : classOrObject.getDeclarations()) {
            KtNamedFunction function2;
            KtNamedFunction ktNamedFunction = declaration2 instanceof KtNamedFunction ? (KtNamedFunction)declaration2 : null;
            if (ktNamedFunction == null || !this.isAnnotated((KtAnnotated)(function2 = ktNamedFunction), fqNames)) continue;
            return function2;
        }
        return null;
    }
}

