/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtil {
    public static boolean comparePublicNonFinalFieldsWithSkip(@NotNull Object first2, @NotNull Object second) {
        if (first2 == null) {
            ReflectionUtil.$$$reportNull$$$0(0);
        }
        if (second == null) {
            ReflectionUtil.$$$reportNull$$$0(1);
        }
        return ReflectionUtil.comparePublicNonFinalFields(first2, second, field2 -> field2.getAnnotation(SkipInEquals.class) == null);
    }

    private static boolean comparePublicNonFinalFields(@NotNull Object first2, @NotNull Object second, @Nullable Predicate<Field> acceptPredicate) {
        if (first2 == null) {
            ReflectionUtil.$$$reportNull$$$0(2);
        }
        if (second == null) {
            ReflectionUtil.$$$reportNull$$$0(3);
        }
        HashSet firstFields = ContainerUtil.newHashSet((Object[])first2.getClass().getFields());
        for (Field field2 : second.getClass().getFields()) {
            if (!firstFields.contains(field2) || !ReflectionUtil.isPublic(field2) || ReflectionUtil.isFinal(field2) || acceptPredicate != null && !acceptPredicate.test(field2)) continue;
            try {
                if (Comparing.equal((Object)field2.get(first2), (Object)field2.get(second))) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private static boolean isPublic(Field field2) {
        return (field2.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(Field field2) {
        return (field2.getModifiers() & 0x10) != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/util/ReflectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "comparePublicNonFinalFieldsWithSkip";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "comparePublicNonFinalFields";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SkipInEquals {
    }
}

