/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.statistics.metrics;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.statistics.AnonymizerUtilsKt;
import org.jetbrains.kotlin.statistics.ValueAnonymizer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0005\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/statistics/metrics/StringAnonymizationPolicy;", "Lorg/jetbrains/kotlin/statistics/ValueAnonymizer;", "", "()V", "validationRegexp", "AllowedListAnonymizer", "ComponentVersionAnonymizer", "RegexControlled", "kotlin-gradle-statistics"})
public abstract class StringAnonymizationPolicy
implements ValueAnonymizer<String> {
    @NotNull
    public abstract String validationRegexp();

    @Override
    public boolean anonymizeOnIdeSize() {
        return ValueAnonymizer.DefaultImpls.anonymizeOnIdeSize(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/statistics/metrics/StringAnonymizationPolicy$AllowedListAnonymizer;", "Lorg/jetbrains/kotlin/statistics/metrics/StringAnonymizationPolicy;", "allowedValues", "", "", "(Ljava/util/Collection;)V", "getAllowedValues", "()Ljava/util/Collection;", "anonymize", "t", "validationRegexp", "Companion", "kotlin-gradle-statistics"})
    public static final class AllowedListAnonymizer
    extends StringAnonymizationPolicy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Collection<String> allowedValues;
        @NotNull
        public static final String UNEXPECTED_VALUE = "UNEXPECTED-VALUE";

        public AllowedListAnonymizer(@NotNull Collection<String> allowedValues) {
            Intrinsics.checkNotNullParameter(allowedValues, (String)"allowedValues");
            this.allowedValues = allowedValues;
        }

        @NotNull
        public final Collection<String> getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        @NotNull
        public String validationRegexp() {
            return "^((UNEXPECTED-VALUE|" + CollectionsKt.joinToString$default((Iterable)this.allowedValues, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ");?)+$";
        }

        @Override
        @NotNull
        public String anonymize(@NotNull String t) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            String[] stringArray = (String[])t;
            if (new Regex(this.validationRegexp()).matches((CharSequence)stringArray)) {
                string2 = t;
            } else {
                stringArray = new String[]{";"};
                string2 = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)t, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)";", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
                    final /* synthetic */ AllowedListAnonymizer this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.this$0.getAllowedValues().contains(it) ? (CharSequence)it : (CharSequence)"UNEXPECTED-VALUE";
                    }
                }), (int)30, null);
            }
            return string2;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/statistics/metrics/StringAnonymizationPolicy$AllowedListAnonymizer$Companion;", "", "()V", "UNEXPECTED_VALUE", "", "kotlin-gradle-statistics"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/statistics/metrics/StringAnonymizationPolicy$ComponentVersionAnonymizer;", "Lorg/jetbrains/kotlin/statistics/metrics/StringAnonymizationPolicy;", "()V", "anonymize", "", "t", "validationRegexp", "kotlin-gradle-statistics"})
    public static final class ComponentVersionAnonymizer
    extends StringAnonymizationPolicy {
        @Override
        @NotNull
        public String validationRegexp() {
            return "(\\d+).(\\d+).(\\d+)-?(dev|snapshot|m\\d?|rc\\d?|beta\\d?)?";
        }

        @Override
        @NotNull
        public String anonymize(@NotNull String t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return AnonymizerUtilsKt.anonymizeComponentVersion(t);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/statistics/metrics/StringAnonymizationPolicy$RegexControlled;", "Lorg/jetbrains/kotlin/statistics/metrics/StringAnonymizationPolicy;", "regex", "", "anonymizeInIde", "", "(Ljava/lang/String;Z)V", "anonymize", "t", "anonymizeOnIdeSize", "validationRegexp", "kotlin-gradle-statistics"})
    public static final class RegexControlled
    extends StringAnonymizationPolicy {
        @NotNull
        private final String regex;
        private final boolean anonymizeInIde;

        public RegexControlled(@NotNull String regex, boolean anonymizeInIde) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            this.regex = regex;
            this.anonymizeInIde = anonymizeInIde;
        }

        @Override
        @NotNull
        public String validationRegexp() {
            return this.regex;
        }

        @Override
        @NotNull
        public String anonymize(@NotNull String t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return t;
        }

        @Override
        public boolean anonymizeOnIdeSize() {
            return this.anonymizeInIde;
        }
    }
}

