/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.compatibility;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.DependencyVersionParser;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinGradleCompatibilityParser;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinWizardVersionParser;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.WizardDefaultDataGeneratorSettings;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u0016*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0016B<\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005R\"\u0010\t\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/compatibility/WizardDefaultDataGeneratorSettings;", "T", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataState;", "", "jsonPath", "", "ktFileName", "parser", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser;", "generator", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser;Lkotlin/jvm/functions/Function1;)V", "getGenerator", "()Lkotlin/jvm/functions/Function1;", "getJsonPath", "()Ljava/lang/String;", "getKtFileName", "getParser", "()Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser;", "generateDefaultData", "applicationVersion", "Companion", "kotlin.project-wizard.core"})
public final class WizardDefaultDataGeneratorSettings<T extends IdeVersionedDataState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String jsonPath;
    @NotNull
    private final String ktFileName;
    @NotNull
    private final IdeVersionedDataParser<T> parser;
    @NotNull
    private final Function1<T, String> generator;

    public WizardDefaultDataGeneratorSettings(@NotNull String jsonPath, @NotNull String ktFileName, @NotNull IdeVersionedDataParser<T> parser2, @NotNull Function1<? super T, String> generator) {
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter((Object)ktFileName, (String)"ktFileName");
        Intrinsics.checkNotNullParameter(parser2, (String)"parser");
        Intrinsics.checkNotNullParameter(generator, (String)"generator");
        this.jsonPath = jsonPath;
        this.ktFileName = ktFileName;
        this.parser = parser2;
        this.generator = generator;
    }

    @NotNull
    public final String getJsonPath() {
        return this.jsonPath;
    }

    @NotNull
    public final String getKtFileName() {
        return this.ktFileName;
    }

    @NotNull
    public final IdeVersionedDataParser<T> getParser() {
        return this.parser;
    }

    @NotNull
    public final Function1<T, String> getGenerator() {
        return this.generator;
    }

    @NotNull
    public final String generateDefaultData(@NotNull String applicationVersion) {
        Intrinsics.checkNotNullParameter((Object)applicationVersion, (String)"applicationVersion");
        InputStream inputStream = WizardDefaultDataGeneratorSettings.class.getResourceAsStream(this.jsonPath);
        Intrinsics.checkNotNull((Object)inputStream);
        byte[] byArray = inputStream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"WizardDefaultDataGenerat\u2026          .readAllBytes()");
        byte[] byArray2 = byArray;
        Charset charset = Charset.forName("utf8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"utf8\")");
        Charset charset2 = charset;
        String jsonData = new String(byArray2, charset2);
        IdeVersionedDataState ideVersionedDataState = this.parser.parseVersionedJson(jsonData, applicationVersion);
        Intrinsics.checkNotNull((Object)ideVersionedDataState);
        IdeVersionedDataState parsedData = ideVersionedDataState;
        return (String)this.generator.invoke((Object)parsedData);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/compatibility/WizardDefaultDataGeneratorSettings$Companion;", "", "()V", "getGenerators", "", "Lorg/jetbrains/kotlin/tools/projectWizard/compatibility/WizardDefaultDataGeneratorSettings;", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataState;", "kotlin.project-wizard.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<WizardDefaultDataGeneratorSettings<? extends IdeVersionedDataState>> getGenerators() {
            Object[] objectArray = new WizardDefaultDataGeneratorSettings[]{new WizardDefaultDataGeneratorSettings("/compatibility/dependencies.json", "DependencyDefaultData.kt", DependencyVersionParser.INSTANCE, getGenerators.1.INSTANCE), new WizardDefaultDataGeneratorSettings("/compatibility/kotlin_gradle_compatibility.json", "KotlinGradleCompatibilityDefaultData.kt", KotlinGradleCompatibilityParser.INSTANCE, getGenerators.2.INSTANCE), new WizardDefaultDataGeneratorSettings("/compatibility/wizard_versions.json", "KotlinWizardVersionDefaultData.kt", KotlinWizardVersionParser.INSTANCE, getGenerators.3.INSTANCE)};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

