/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.maven;

import com.intellij.indexing.shared.download.SharedIndexAuthParams;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.java.maven.MavenPackageId;
import com.intellij.indexing.shared.java.maven.MavenSharedIndexes;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0013\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0016J\b\u0010\u001d\u001a\u00020\nH\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/indexing/shared/java/maven/MavenLibraryIndexLookupRequest;", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "pkg", "Lcom/intellij/indexing/shared/java/maven/MavenPackageId;", "(Lcom/intellij/indexing/shared/java/maven/MavenPackageId;)V", "authId", "Lcom/intellij/indexing/shared/download/SharedIndexAuthParams;", "getAuthId", "()Lcom/intellij/indexing/shared/download/SharedIndexAuthParams;", "kind", "", "getKind", "()Ljava/lang/String;", "getPkg", "()Lcom/intellij/indexing/shared/java/maven/MavenPackageId;", "presentableChunkName", "getPresentableChunkName", "useListJsonIndexToSkipUrls", "", "getUseListJsonIndexToSkipUrls", "()Z", "baseUrl", "equals", "other", "", "hashCode", "", "indexUrls", "", "toString", "intellij.indexing.shared.java"})
@SourceDebugExtension(value={"SMAP\nMavenLibraryIndexLookupRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenLibraryIndexLookupRequest.kt\ncom/intellij/indexing/shared/java/maven/MavenLibraryIndexLookupRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1549#2:54\n1620#2,3:55\n*S KotlinDebug\n*F\n+ 1 MavenLibraryIndexLookupRequest.kt\ncom/intellij/indexing/shared/java/maven/MavenLibraryIndexLookupRequest\n*L\n46#1:54\n46#1:55,3\n*E\n"})
public final class MavenLibraryIndexLookupRequest
implements SharedIndexLookupRequest {
    @NotNull
    private final MavenPackageId pkg;
    @NotNull
    private final String kind;

    public MavenLibraryIndexLookupRequest(@NotNull MavenPackageId pkg) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        this.pkg = pkg;
        this.kind = "mvn";
    }

    @NotNull
    public final MavenPackageId getPkg() {
        return this.pkg;
    }

    @Override
    @NotNull
    public String getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public String baseUrl() {
        return MavenSharedIndexes.INSTANCE.getMavenFeedUrl();
    }

    @Override
    public boolean getUseListJsonIndexToSkipUrls() {
        return true;
    }

    @Override
    @NotNull
    public String getPresentableChunkName() {
        Object[] objectArray = new Object[]{this.pkg.asString()};
        String string = SharedIndexesBundle.message("presentable.chunk.name.the.maven", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"presentable.chu\u2026e.maven\", pkg.asString())");
        return string;
    }

    @Override
    @Nullable
    public SharedIndexAuthParams getAuthId() {
        return null;
    }

    @Override
    @NotNull
    public List<String> indexUrls() {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String version = this.pkg.getVersion();
        String[] stringArray = new String[]{"."};
        List elements = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)3, (int)2, null);
        String majorVersion = (String)CollectionsKt.first((List)elements);
        String majorMinorVersion = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)elements, (int)2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        Object[] objectArray = new String[]{"package/" + this.pkg.getGroupId() + ":" + this.pkg.getArtifactId() + ":" + version};
        List result2 = CollectionsKt.mutableListOf((Object[])objectArray);
        if (!Intrinsics.areEqual((Object)version, (Object)majorMinorVersion)) {
            ((Collection)result2).add("major-minor-version/" + this.pkg.getGroupId() + ":" + this.pkg.getArtifactId() + ":" + majorMinorVersion);
        }
        if (!Intrinsics.areEqual((Object)version, (Object)majorVersion) && !Intrinsics.areEqual((Object)majorVersion, (Object)majorMinorVersion)) {
            ((Collection)result2).add("major-version/" + this.pkg.getGroupId() + ":" + this.pkg.getArtifactId() + ":" + majorVersion);
        }
        String pathPrefix = MavenSharedIndexes.INSTANCE.getMavenFeedUrl();
        Iterable $this$map$iv = result2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void var16_16 = it;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = var16_16.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            collection.add(string2);
        }
        $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(pathPrefix + "/" + it);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public int hashCode() {
        return this.pkg.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof MavenLibraryIndexLookupRequest && Intrinsics.areEqual((Object)this.pkg, (Object)((MavenLibraryIndexLookupRequest)other).pkg);
    }

    @NotNull
    public String toString() {
        return "MavenLibraryIndexRequest(" + this.pkg + ")";
    }
}

