/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.performanceTesting;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.indexing.shared.performanceTesting.CheckSharedIndices;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processors;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.errors.ErrorCollector;
import com.jetbrains.performancePlugin.utils.errors.ToDirectoryWritingErrorCollector;
import com.jetbrains.performancePlugin.utils.indexes.CurrentIndexedFileResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u00020\r2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/indexing/shared/performanceTesting/CheckSharedIndices;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "checkFilesAvailableInSharedIndex", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "errorCollector", "Lcom/jetbrains/performancePlugin/utils/errors/ErrorCollector;", "project", "Lcom/intellij/openapi/project/Project;", "filterOnlyIndexedFilesInPlace", "allFiles", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "SharedIndexLogInfo", "intellij.indexing.shared.performanceTesting"})
public final class CheckSharedIndices
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%checkSharedIndices";
    @NotNull
    private static final Logger LOG;
    private static final int NUMBER_OF_ERRORS_LIMIT = 100;

    public CheckSharedIndices(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        Project project2 = project;
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> CheckSharedIndices._execute$lambda$0(project2, this, actionCallback));
        return Promises.toPromise((ActionCallback)((ActionCallback)actionCallback));
    }

    private final void checkFilesAvailableInSharedIndex(ProgressIndicator indicator, ErrorCollector errorCollector, Project project) {
        if (!SharedIndexChunkConfiguration.getInstance().hasAnyChunk(false)) {
            boolean bl = false;
            String string = "No shared indexes chunks have been attached to the project";
            throw new IllegalStateException(string.toString());
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(project, indicator, errorCollector, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ ErrorCollector $errorCollector;
            final /* synthetic */ CheckSharedIndices this$0;
            {
                this.$project = $project;
                this.$indicator = $indicator;
                this.$errorCollector = $errorCollector;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                VirtualFile it;
                void $this$mapValuesTo$iv$iv322;
                Map allHashIds = com.intellij.indexing.shared.performanceTesting.CheckSharedIndices$Companion.access$collectAllSharedIndexHashIds(CheckSharedIndices.Companion, this.$project, this.$indicator);
                CheckSharedIndices.access$getLOG$cp().info("Shared hash index contains the following number of hashes per indexId " + CollectionsKt.joinToString$default((Iterable)allHashIds.entrySet(), (CharSequence)"", null, null, (int)0, null, (Function1)checkFilesAvailableInSharedIndex.1.INSTANCE, (int)30, null));
                Set fileIds = com.intellij.indexing.shared.performanceTesting.CheckSharedIndices$Companion.access$mapHashIdsToLocalFileIds(CheckSharedIndices.Companion, allHashIds, this.$errorCollector);
                Set sharedIndexFiles = com.intellij.indexing.shared.performanceTesting.CheckSharedIndices$Companion.access$collectSharedIndexFiles(CheckSharedIndices.Companion, fileIds, this.$indicator, this.$project);
                int sharedIndexFilesNumber = sharedIndexFiles.size();
                CheckSharedIndices.access$getLOG$cp().info("Project files indexed by shared indexes: " + sharedIndexFilesNumber);
                Map $this$mapValues$iv = CurrentIndexedFileResolver.INSTANCE.getAllToBeIndexedFilesInProject(this.$project, this.$indicator);
                boolean $i$f$mapValues22 = false;
                Map map = $this$mapValues$iv;
                Map destination$iv$iv22 = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv322.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Object object = destination$iv$iv22;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    K k = it$iv$iv.getKey();
                    Map map2 = object;
                    boolean bl2 = false;
                    Set set = CollectionsKt.toMutableSet((Iterable)((Iterable)it.getValue()));
                    map2.put(k, set);
                }
                Map allFiles2 = destination$iv$iv22;
                Iterable $i$f$mapValues22 = allFiles2.values();
                int $this$mapValuesTo$iv$iv322 = 0;
                for (E e : $i$f$mapValues22) {
                    int n;
                    void set;
                    $this$associateByTo$iv$iv$iv = (Set)e;
                    int n2 = $this$mapValuesTo$iv$iv322;
                    boolean bl = false;
                    Iterable $this$count$iv = (Iterable)set;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (E element$iv : $this$count$iv) {
                            it = (VirtualFile)element$iv;
                            boolean bl3 = false;
                            if (!(!it.isDirectory()) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int n3 = n;
                    $this$mapValuesTo$iv$iv322 = n2 + n3;
                }
                int numberOfProjectFiles = $this$mapValuesTo$iv$iv322;
                CheckSharedIndices.access$getLOG$cp().info("Total number of project files: " + numberOfProjectFiles);
                CheckSharedIndices.access$filterOnlyIndexedFilesInPlace(this.this$0, allFiles2);
                Iterable $this$mapValuesTo$iv$iv322 = allFiles2.values();
                int destination$iv$iv22 = 0;
                for (T t : $this$mapValuesTo$iv$iv322) {
                    void it2;
                    Set bl = (Set)t;
                    int n = destination$iv$iv22;
                    boolean bl4 = false;
                    int n4 = it2.size();
                    destination$iv$iv22 = n + n4;
                }
                int numberOfIndexedFiles = destination$iv$iv22;
                CheckSharedIndices.access$getLOG$cp().info("Total number of indexed project files: " + numberOfIndexedFiles);
                SharedIndexLogInfo logInfo = new SharedIndexLogInfo(sharedIndexFilesNumber, numberOfProjectFiles, numberOfIndexedFiles);
                com.intellij.indexing.shared.performanceTesting.CheckSharedIndices$Companion.access$saveLogInfo(CheckSharedIndices.Companion, logInfo);
                if (sharedIndexFiles.isEmpty()) {
                    throw new AssertionError((Object)"Shared indexes don't contain any files");
                }
                String message = com.intellij.indexing.shared.performanceTesting.CheckSharedIndices$Companion.access$getMessageForFilesNotAvailableInSharedIndex(CheckSharedIndices.Companion, sharedIndexFiles, allFiles2);
                if (((CharSequence)message).length() == 0) {
                    CheckSharedIndices.access$getLOG$cp().info("All project files are available in the shared index.");
                } else {
                    CheckSharedIndices.access$getLOG$cp().info("Files without shared index: ");
                    CheckSharedIndices.access$getLOG$cp().info(message);
                }
            }
        }));
    }

    private final void filterOnlyIndexedFilesInPlace(Map<IndexableFilesIterator, ? extends Set<VirtualFile>> allFiles2) {
        Set contentDependentIndexes2 = CheckSharedIndices.Companion.getContentDependentIndexes();
        Iterator<Map.Entry<IndexableFilesIterator, ? extends Set<VirtualFile>>> iterator = allFiles2.entrySet().iterator();
        while (iterator.hasNext()) {
            Set<VirtualFile> value = iterator.next().getValue();
            value.removeIf(arg_0 -> CheckSharedIndices.filterOnlyIndexedFilesInPlace$lambda$2((Function1)new Function1<VirtualFile, Boolean>(contentDependentIndexes2){
                final /* synthetic */ Set<ID<?, ?>> $contentDependentIndexes;
                {
                    this.$contentDependentIndexes = $contentDependentIndexes;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(@NotNull VirtualFile fileOrDir) {
                    boolean bl;
                    block4: {
                        void $this$any$iv;
                        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                        if (fileOrDir.isDirectory()) {
                            return true;
                        }
                        int fileId = FileBasedIndex.getFileId((VirtualFile)fileOrDir);
                        List list = IndexingStamp.getNontrivialFileIndexedStates((int)fileId);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNontrivialFileIndexedStates(fileId)");
                        List nonTrivialIds = list;
                        Iterable iterable = nonTrivialIds;
                        Set<ID<?, ?>> set = this.$contentDependentIndexes;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                ID it = (ID)element$iv;
                                boolean bl2 = false;
                                if (!set.contains(it)) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    boolean hasBeenIndexed = bl;
                    return !hasBeenIndexed;
                }
            }, arg_0));
        }
    }

    private static final void _execute$lambda$0(Project $project, CheckSharedIndices this$0, ActionCallbackProfilerStopper $actionCallback) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$actionCallback, (String)"$actionCallback");
        String string = PerformanceTestingBundle.message((String)"checking.shared.indexes", (Object[])new Object[0]);
        new Task.Modal($project, this$0, $actionCallback, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ CheckSharedIndices this$0;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$actionCallback = $actionCallback;
                super($project, $super_call_param$1, false);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Path failureDiagnosticDirectory = com.intellij.indexing.shared.performanceTesting.CheckSharedIndices$Companion.access$getFailureDiagnosticDirectory(CheckSharedIndices.Companion);
                try {
                    ErrorCollector errorCollector = (ErrorCollector)new ToDirectoryWritingErrorCollector("errors-of-check-shared-indices", failureDiagnosticDirectory, 100);
                    CheckSharedIndices.access$checkFilesAvailableInSharedIndex(this.this$0, indicator, errorCollector, this.$project);
                    if (errorCollector.getNumberOfErrors() > 0) {
                        throw new AssertionError((Object)"Some errors have been collected");
                    }
                    this.$actionCallback.setDone();
                }
                catch (Throwable e) {
                    CheckSharedIndices.access$getLOG$cp().error("Check shared indices command has failed. See failure details in " + failureDiagnosticDirectory, e);
                    this.$actionCallback.reject(e.getMessage());
                }
            }
        }.queue();
    }

    private static final boolean filterOnlyIndexedFilesInPlace$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$filterOnlyIndexedFilesInPlace(CheckSharedIndices $this, Map allFiles2) {
        $this.filterOnlyIndexedFilesInPlace(allFiles2);
    }

    public static final /* synthetic */ void access$checkFilesAvailableInSharedIndex(CheckSharedIndices $this, ProgressIndicator indicator, ErrorCollector errorCollector, Project project) {
        $this.checkFilesAvailableInSharedIndex(indicator, errorCollector, project);
    }

    static {
        Logger logger = Logger.getInstance(CheckSharedIndices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(CheckSharedIndices::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0013\u001a\u001c\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000b0\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u001d\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u000b0\u0014H\u0002J8\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2 \u0010\"\u001a\u001c\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000b0\u00142\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lcom/intellij/indexing/shared/performanceTesting/CheckSharedIndices$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NUMBER_OF_ERRORS_LIMIT", "", "PREFIX", "", "contentDependentIndexes", "", "Lcom/intellij/util/indexing/ID;", "getContentDependentIndexes", "()Ljava/util/Set;", "failureDiagnosticDirectory", "Ljava/nio/file/Path;", "getFailureDiagnosticDirectory", "()Ljava/nio/file/Path;", "collectAllSharedIndexHashIds", "", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "collectSharedIndexFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileIds", "getMessageForFilesNotAvailableInSharedIndex", "sharedIndexFiles", "projectFiles", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "mapHashIdsToLocalFileIds", "indexIdToHashIds", "errorCollector", "Lcom/jetbrains/performancePlugin/utils/errors/ErrorCollector;", "saveLogInfo", "", "logInfo", "Lcom/intellij/indexing/shared/performanceTesting/CheckSharedIndices$SharedIndexLogInfo;", "stopIfTooManyErrors", "intellij.indexing.shared.performanceTesting"})
    @SourceDebugExtension(value={"SMAP\nCheckSharedIndices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckSharedIndices.kt\ncom/intellij/indexing/shared/performanceTesting/CheckSharedIndices$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,271:1\n215#2,2:272\n*S KotlinDebug\n*F\n+ 1 CheckSharedIndices.kt\ncom/intellij/indexing/shared/performanceTesting/CheckSharedIndices$Companion\n*L\n178#1:272,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getFailureDiagnosticDirectory() {
            Path path;
            String property = System.getProperty("check.shared.indices.command.failure.diagnostic.directory");
            if (property != null) {
                Path path2 = Paths.get(property, new String[0]);
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"{\n          Paths.get(property)\n        }");
            } else {
                Path path3;
                try {
                    path3 = FileUtil.createTempDirectory((String)"compare-indices", (String)"failure").toPath();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Path path4 = path3;
                path = path4;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"try {\n          FileUtil\u2026imeException(e)\n        }");
            }
            return path;
        }

        private final void stopIfTooManyErrors(ErrorCollector errorCollector) {
            if (errorCollector.getNumberOfErrors() > 100) {
                throw new AssertionError((Object)"Too many errors have been collected");
            }
        }

        private final void saveLogInfo(SharedIndexLogInfo logInfo) {
            String string = System.getProperty("json.shared.index.info");
            if (string == null) {
                return;
            }
            String sharedIndexInfoJson = string;
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
                objectMapper.writeValue(new File(sharedIndexInfoJson), (Object)logInfo);
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage());
            }
        }

        private final String getMessageForFilesNotAvailableInSharedIndex(Set<? extends VirtualFile> sharedIndexFiles, Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> projectFiles) {
            StringBuilder message = new StringBuilder();
            Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> $this$forEach$iv = projectFiles;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<IndexableFilesIterator, ? extends Set<? extends VirtualFile>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> element$iv;
                Map.Entry<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> entry = element$iv = iterator.next();
                boolean bl = false;
                IndexableFilesIterator provider = entry.getKey();
                Set<? extends VirtualFile> providerFiles = entry.getValue();
                Set nonSharedFiles = SetsKt.minus(providerFiles, (Iterable)sharedIndexFiles);
                if (!(!((Collection)nonSharedFiles).isEmpty())) continue;
                int limit = SystemProperties.getIntProperty((String)"check.shared.indices.command.unavailable.files.limit", (int)5);
                message.append(provider.getDebugName()).append(" has ").append(nonSharedFiles.size()).append(" ").append(StringUtil.pluralize((String)"file", (int)nonSharedFiles.size())).append(" not available in shared index (only ").append(limit).append(" first are shown): ").append("\n");
                nonSharedFiles.stream().limit(limit).map(arg_0 -> Companion.getMessageForFilesNotAvailableInSharedIndex$lambda$2$lambda$0(getMessageForFilesNotAvailableInSharedIndex.1.1.INSTANCE, arg_0)).forEach(arg_0 -> Companion.getMessageForFilesNotAvailableInSharedIndex$lambda$2$lambda$1((Function1)new Function1<String, Unit>(message){
                    final /* synthetic */ StringBuilder $message;
                    {
                        this.$message = $message;
                        super(1);
                    }

                    public final void invoke(@Nullable String path) {
                        this.$message.append("    ").append(path).append("\n");
                    }
                }, arg_0));
            }
            String string = message.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.toString()");
            return string;
        }

        private final Set<VirtualFile> collectSharedIndexFiles(Set<Integer> fileIds, ProgressIndicator indicator, Project project) {
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            int finished = 0;
            Set files = new HashSet();
            GlobalSearchScope globalSearchScope = GlobalSearchScope.everythingScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"everythingScope(project)");
            GlobalSearchScope allScope = globalSearchScope;
            Iterator<Integer> iterator = fileIds.iterator();
            while (iterator.hasNext()) {
                VirtualFile file;
                int fileId = ((Number)iterator.next()).intValue();
                if (ManagingFS.getInstance().findFileById(fileId) == null) continue;
                if (!file.isDirectory() && allScope.contains(file)) {
                    files.add(file);
                }
                indicator.setFraction((double)(++finished) * 1.0 / (double)fileIds.size());
                indicator.setText2(file.getPath());
            }
            return files;
        }

        private final Set<Integer> mapHashIdsToLocalFileIds(Map<ID<?, ?>, ? extends Set<Long>> indexIdToHashIds, ErrorCollector errorCollector) throws StorageException {
            Set allLocalFileIds = new HashSet();
            for (Map.Entry<ID<?, ?>, Set<Long>> entry : indexIdToHashIds.entrySet()) {
                ID<?, ?> indexId2 = entry.getKey();
                Set<Long> hashIds = entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)FileContentHashIndex.getFileContentHashIndex(indexId2)), (String)"getFileContentHashIndex(indexId)");
                Map fileIdToHashId = new HashMap();
                Iterator<Long> iterator = hashIds.iterator();
                while (iterator.hasNext()) {
                    FileContentHashIndex hashIndex;
                    long compositeHashId = ((Number)iterator.next()).longValue();
                    hashIndex.getData(compositeHashId).forEach((arg_0, arg_1) -> Companion.mapHashIdsToLocalFileIds$lambda$3((Function2)new Function2<Integer, Void, Boolean>((Map<Integer, Long>)fileIdToHashId, compositeHashId, errorCollector, indexId2){
                        final /* synthetic */ Map<Integer, Long> $fileIdToHashId;
                        final /* synthetic */ long $compositeHashId;
                        final /* synthetic */ ErrorCollector $errorCollector;
                        final /* synthetic */ ID<?, ?> $indexId;
                        {
                            this.$fileIdToHashId = $fileIdToHashId;
                            this.$compositeHashId = $compositeHashId;
                            this.$errorCollector = $errorCollector;
                            this.$indexId = $indexId;
                            super(2);
                        }

                        @NotNull
                        public final Boolean invoke(int fileId, @Nullable Void void_) {
                            Long previousHashId = this.$fileIdToHashId.put(fileId, this.$compositeHashId);
                            if (previousHashId != null && !Comparing.equal((Object)previousHashId, (Object)this.$compositeHashId)) {
                                VirtualFile file;
                                VirtualFile virtualFile = file = ManagingFS.getInstance().findFileById(fileId);
                                String fileMsg = virtualFile != null ? virtualFile.getPath() + " (fileId=" + fileId + ")" : "id=" + fileId;
                                this.$errorCollector.addError((Throwable)((Object)new AssertionError((Object)("Duplicated file " + fileMsg + " for hashes " + previousHashId + " and " + this.$compositeHashId + " of index " + this.$indexId.getName()))));
                            }
                            com.intellij.indexing.shared.performanceTesting.CheckSharedIndices$Companion.access$stopIfTooManyErrors(CheckSharedIndices.Companion, this.$errorCollector);
                            return true;
                        }
                    }, arg_0, arg_1));
                }
                allLocalFileIds.addAll(fileIdToHashId.keySet());
            }
            return allLocalFileIds;
        }

        private final Map<ID<?, ?>, Set<Long>> collectAllSharedIndexHashIds(Project project, ProgressIndicator indicator) throws StorageException {
            indicator.setText(PerformanceTestingBundle.message((String)"checking.shared.indexes.collecting.shared.files", (Object[])new Object[0]));
            indicator.setIndeterminate(true);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
            GlobalSearchScope allScope = globalSearchScope;
            Set<ID<?, ?>> contentDependentIndexIds = this.getContentDependentIndexes();
            HashMap indexIdToHashIds = new HashMap();
            for (ID<?, ?> id : contentDependentIndexIds) {
                FileContentHashIndex hashIndex;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)FileContentHashIndex.getFileContentHashIndex(id)), (String)"getFileContentHashIndex(id)");
                Set allHashIds = new HashSet();
                hashIndex.processAllKeys(Processors.cancelableCollectProcessor((Collection)allHashIds), allScope, null);
                ((Map)indexIdToHashIds).put(id, allHashIds);
            }
            return indexIdToHashIds;
        }

        private final Set<ID<?, ?>> getContentDependentIndexes() {
            return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()), (Function1)contentDependentIndexes.1.INSTANCE), (Function1)contentDependentIndexes.2.INSTANCE));
        }

        private static final String getMessageForFilesNotAvailableInSharedIndex$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        private static final void getMessageForFilesNotAvailableInSharedIndex$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final boolean mapHashIdsToLocalFileIds$lambda$3(Function2 $tmp0, int p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke((Object)p0, p1);
        }

        public static final /* synthetic */ Map access$collectAllSharedIndexHashIds(Companion $this, Project project, ProgressIndicator indicator) {
            return $this.collectAllSharedIndexHashIds(project, indicator);
        }

        public static final /* synthetic */ Set access$mapHashIdsToLocalFileIds(Companion $this, Map indexIdToHashIds, ErrorCollector errorCollector) {
            return $this.mapHashIdsToLocalFileIds(indexIdToHashIds, errorCollector);
        }

        public static final /* synthetic */ Set access$collectSharedIndexFiles(Companion $this, Set fileIds, ProgressIndicator indicator, Project project) {
            return $this.collectSharedIndexFiles(fileIds, indicator, project);
        }

        public static final /* synthetic */ void access$saveLogInfo(Companion $this, SharedIndexLogInfo logInfo) {
            $this.saveLogInfo(logInfo);
        }

        public static final /* synthetic */ String access$getMessageForFilesNotAvailableInSharedIndex(Companion $this, Set sharedIndexFiles, Map projectFiles) {
            return $this.getMessageForFilesNotAvailableInSharedIndex(sharedIndexFiles, projectFiles);
        }

        public static final /* synthetic */ void access$stopIfTooManyErrors(Companion $this, ErrorCollector errorCollector) {
            $this.stopIfTooManyErrors(errorCollector);
        }

        public static final /* synthetic */ Path access$getFailureDiagnosticDirectory(Companion $this) {
            return $this.getFailureDiagnosticDirectory();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/performanceTesting/CheckSharedIndices$SharedIndexLogInfo;", "", "filesIndexedBySharedIndex", "", "allProjectFiles", "allIndexedFiles", "(III)V", "getAllIndexedFiles", "()I", "getAllProjectFiles", "getFilesIndexedBySharedIndex", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.indexing.shared.performanceTesting"})
    private static final class SharedIndexLogInfo {
        private final int filesIndexedBySharedIndex;
        private final int allProjectFiles;
        private final int allIndexedFiles;

        public SharedIndexLogInfo(int filesIndexedBySharedIndex, int allProjectFiles, int allIndexedFiles) {
            this.filesIndexedBySharedIndex = filesIndexedBySharedIndex;
            this.allProjectFiles = allProjectFiles;
            this.allIndexedFiles = allIndexedFiles;
        }

        public final int getFilesIndexedBySharedIndex() {
            return this.filesIndexedBySharedIndex;
        }

        public final int getAllProjectFiles() {
            return this.allProjectFiles;
        }

        public final int getAllIndexedFiles() {
            return this.allIndexedFiles;
        }

        public final int component1() {
            return this.filesIndexedBySharedIndex;
        }

        public final int component2() {
            return this.allProjectFiles;
        }

        public final int component3() {
            return this.allIndexedFiles;
        }

        @NotNull
        public final SharedIndexLogInfo copy(int filesIndexedBySharedIndex, int allProjectFiles, int allIndexedFiles) {
            return new SharedIndexLogInfo(filesIndexedBySharedIndex, allProjectFiles, allIndexedFiles);
        }

        public static /* synthetic */ SharedIndexLogInfo copy$default(SharedIndexLogInfo sharedIndexLogInfo, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = sharedIndexLogInfo.filesIndexedBySharedIndex;
            }
            if ((n4 & 2) != 0) {
                n2 = sharedIndexLogInfo.allProjectFiles;
            }
            if ((n4 & 4) != 0) {
                n3 = sharedIndexLogInfo.allIndexedFiles;
            }
            return sharedIndexLogInfo.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "SharedIndexLogInfo(filesIndexedBySharedIndex=" + this.filesIndexedBySharedIndex + ", allProjectFiles=" + this.allProjectFiles + ", allIndexedFiles=" + this.allIndexedFiles + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.filesIndexedBySharedIndex);
            result2 = result2 * 31 + Integer.hashCode(this.allProjectFiles);
            result2 = result2 * 31 + Integer.hashCode(this.allIndexedFiles);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SharedIndexLogInfo)) {
                return false;
            }
            SharedIndexLogInfo sharedIndexLogInfo = (SharedIndexLogInfo)other;
            if (this.filesIndexedBySharedIndex != sharedIndexLogInfo.filesIndexedBySharedIndex) {
                return false;
            }
            if (this.allProjectFiles != sharedIndexLogInfo.allProjectFiles) {
                return false;
            }
            return this.allIndexedFiles == sharedIndexLogInfo.allIndexedFiles;
        }
    }
}

