/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaSdkUtil {
    @Deprecated(forRemoval=true)
    @NotNull
    public static List<File> getJdkClassesRoots(@NotNull File home, boolean isJre) {
        if (home == null) {
            JavaSdkUtil.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.map(JavaSdkUtil.getJdkClassesRoots(home.toPath(), isJre), Path::toFile);
        if (list == null) {
            JavaSdkUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<Path> getJdkClassesRoots(@NotNull Path home, boolean isJre) {
        Path classesDir;
        Path classesZip;
        Path toolsJar;
        Path[] jarDirs;
        Path libDir;
        Path fileName;
        if (home == null) {
            JavaSdkUtil.$$$reportNull$$$0(2);
        }
        if ((fileName = home.getFileName()) != null && "Home".equals(fileName.toString()) && Files.exists(home.resolve("../Classes/classes.jar"), new LinkOption[0])) {
            libDir = home.resolve("lib");
            Path classesDir2 = home.resolveSibling("Classes");
            Path libExtDir = libDir.resolve("ext");
            Path libEndorsedDir = libDir.resolve("endorsed");
            jarDirs = new Path[]{libEndorsedDir, libDir, classesDir2, libExtDir};
        } else if (Files.exists(home.resolve("lib/jrt-fs.jar"), new LinkOption[0])) {
            jarDirs = new Path[]{};
        } else {
            libDir = home.resolve(isJre ? "lib" : "jre/lib");
            Path libExtDir = libDir.resolve("ext");
            Path[] libEndorsedDir = libDir.resolve("endorsed");
            jarDirs = new Path[]{libEndorsedDir, libDir, libExtDir};
        }
        ArrayList<Path> rootFiles = new ArrayList<Path>();
        if (Registry.is((String)"project.structure.add.tools.jar.to.new.jdk", (boolean)false) && Files.isRegularFile(toolsJar = home.resolve("lib/tools.jar"), new LinkOption[0])) {
            rootFiles.add(toolsJar);
        }
        Set pathFilter = CollectionFactory.createFilePathSet();
        for (Path jarDir : jarDirs) {
            if (jarDir == null || !Files.isDirectory(jarDir, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(jarDir, "*.jar");){
                for (Path jarFile : stream) {
                    String canonicalPath;
                    String jarFileName = jarFile.getFileName().toString();
                    if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath = JavaSdkUtil.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath)) continue;
                    rootFiles.add(jarFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (ContainerUtil.exists(rootFiles, path -> path.getFileName().toString().startsWith("ibm"))) {
            try (Stream<Path> paths2 = Files.walk(isJre ? home : home.resolve("jre"), new FileVisitOption[0]);){
                paths2.filter(path -> path.getFileName().toString().equals("vm.jar")).findFirst().ifPresent(rootFiles::add);
            }
            catch (IOException paths2) {
                // empty catch block
            }
        }
        if (Files.isRegularFile(classesZip = home.resolve("lib/classes.zip"), new LinkOption[0])) {
            rootFiles.add(classesZip);
        }
        if (rootFiles.isEmpty() && Files.isDirectory(classesDir = home.resolve("classes"), new LinkOption[0])) {
            rootFiles.add(classesDir);
        }
        ArrayList<Path> arrayList = rootFiles;
        if (arrayList == null) {
            JavaSdkUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    private static String getCanonicalPath(Path file) {
        try {
            return file.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/JavaSdkUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/JavaSdkUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkClassesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdkClassesRoots";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

