/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.injection.MarkdownCodeFenceUtils;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuote;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.util.MarkdownPsiStructureUtil;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016JF\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J \u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/editor/MarkdownEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "preprocessEnter", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "processBlockQuote", "", "element", "Lcom/intellij/psi/PsiElement;", "shouldAbortIndentation", "", "offset", "shouldHandle", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownEnterHandler.kt\norg/intellij/plugins/markdown/editor/MarkdownEnterHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class MarkdownEnterHandler
extends EnterHandlerDelegateAdapter {
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        int offset = editor2.getCaretModel().getOffset();
        PsiElement psiElement = MarkdownPsiUtil.INSTANCE.findNonWhiteSpacePrevSibling(file, offset);
        if (psiElement == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement element2 = psiElement;
        if (!file.isValid() || !this.shouldHandle(editor2, dataContext, element2)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Object object = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"caretOffset.get()");
        if (this.shouldAbortIndentation(file, editor2, ((Number)object).intValue())) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)"\n");
            return EnterHandlerDelegate.Result.Stop;
        }
        MarkdownCodeFence fence = MarkdownCodeFenceUtils.INSTANCE.getCodeFence(element2);
        if (fence != null && !MarkdownPsiStructureUtil.INSTANCE.isTopLevel$intellij_markdown_core((ASTNode)fence)) {
            String string = MarkdownCodeFenceUtils.getIndent(fence);
            if (string == null) {
                return EnterHandlerDelegate.Result.Continue;
            }
            String indent = string;
            EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)("\n" + indent));
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        int offset = editor2.getCaretModel().getOffset();
        PsiElement psiElement = MarkdownPsiUtil.INSTANCE.findNonWhiteSpacePrevSibling(file, offset);
        if (psiElement == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement element2 = psiElement;
        if (!file.isValid() || !this.shouldHandle(editor2, dataContext, element2)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        this.processBlockQuote(editor2, element2);
        return EnterHandlerDelegate.Result.Continue;
    }

    private final void processBlockQuote(Editor editor2, PsiElement element2) {
        MarkdownBlockQuote markdownBlockQuote = (MarkdownBlockQuote)PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownBlockQuote.class);
        if (markdownBlockQuote == null) {
            return;
        }
        MarkdownBlockQuote quote = markdownBlockQuote;
        CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getCustomSettings((PsiFile)quote.getContainingFile(), MarkdownCustomCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(quote.\u2026tyleSettings::class.java)");
        MarkdownCustomCodeStyleSettings markdown = (MarkdownCustomCodeStyleSettings)customCodeStyleSettings;
        Object toAdd = ">";
        if (markdown.FORCE_ONE_SPACE_AFTER_BLOCKQUOTE_SYMBOL) {
            toAdd = (String)toAdd + " ";
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)toAdd);
    }

    private final boolean shouldAbortIndentation(PsiFile file, Editor editor2, int offset) {
        block9: {
            block8: {
                boolean bl;
                if (!(file instanceof MarkdownFile)) break block8;
                PsiElement psiElement = file.findElementAt(offset - 1);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl2 = false;
                    ASTNode aSTNode = it.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.node");
                    bl = MarkdownCodeFenceUtils.INSTANCE.inCodeFence(aSTNode);
                } else {
                    bl = false;
                }
                if (!bl) break block9;
            }
            return false;
        }
        String text2 = ((Object)editor2.getDocument().getCharsSequence()).toString();
        int cur = offset - 1;
        while (cur > 0) {
            Character c = StringsKt.getOrNull((CharSequence)text2, (int)cur);
            if (c == null) {
                --cur;
                continue;
            }
            if (!CharsKt.isWhitespace((char)c.charValue())) break;
            char c2 = '\n';
            if (c.charValue() == c2) {
                return true;
            }
            --cur;
        }
        return false;
    }

    private final boolean shouldHandle(Editor editor2, DataContext dataContext, PsiElement element2) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (!editor2.getDocument().isWritable()) {
            return false;
        }
        if (!(InjectedLanguageManager.getInstance((Project)project2).getTopLevelFile(element2) instanceof MarkdownFile)) {
            return false;
        }
        return !editor2.isViewer();
    }
}

