/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.authorization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirerHttp;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.net.http.HttpHeaders;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.time.DateUtils;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0012\u0013B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthCredentialsAcquirer;", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "googleAppCred", "Lorg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils$GoogleAppCredentials;", "authorizationCodeUrl", "Lcom/intellij/util/Url;", "codeVerifier", "", "(Lorg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils$GoogleAppCredentials;Lcom/intellij/util/Url;Ljava/lang/String;)V", "acquireCredentials", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer$AcquireCredentialsResult;", "code", "getCredentials", "responseBody", "responseHeaders", "Ljava/net/http/HttpHeaders;", "getTokenUrlWithParameters", "AuthorizationResponseData", "Companion", "intellij.markdown.core"})
public final class GoogleOAuthCredentialsAcquirer
implements OAuthCredentialsAcquirer<GoogleCredentials> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GoogleAccountsUtils.GoogleAppCredentials googleAppCred;
    @NotNull
    private final Url authorizationCodeUrl;
    @NotNull
    private final String codeVerifier;
    @NotNull
    private static final String authGrantType = "authorization_code";

    public GoogleOAuthCredentialsAcquirer(@NotNull GoogleAccountsUtils.GoogleAppCredentials googleAppCred, @NotNull Url authorizationCodeUrl, @NotNull String codeVerifier) {
        Intrinsics.checkNotNullParameter((Object)googleAppCred, (String)"googleAppCred");
        Intrinsics.checkNotNullParameter((Object)authorizationCodeUrl, (String)"authorizationCodeUrl");
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        this.googleAppCred = googleAppCred;
        this.authorizationCodeUrl = authorizationCodeUrl;
        this.codeVerifier = codeVerifier;
    }

    @NotNull
    public OAuthCredentialsAcquirer.AcquireCredentialsResult<GoogleCredentials> acquireCredentials(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return OAuthCredentialsAcquirerHttp.INSTANCE.requestToken(this.getTokenUrlWithParameters(code), (Function2)new Function2<String, HttpHeaders, GoogleCredentials>(this){
            final /* synthetic */ GoogleOAuthCredentialsAcquirer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final GoogleCredentials invoke(@NotNull String body, @NotNull HttpHeaders headers2) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
                return GoogleOAuthCredentialsAcquirer.access$getCredentials(this.this$0, body, headers2);
            }
        });
    }

    private final Url getTokenUrlWithParameters(String code) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)this.googleAppCred.getClientId()), TuplesKt.to((Object)"client_secret", (Object)this.googleAppCred.getClientSecret()), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"code_verifier", (Object)this.codeVerifier), TuplesKt.to((Object)"grant_type", (Object)authGrantType), TuplesKt.to((Object)"redirect_uri", (Object)this.authorizationCodeUrl.toExternalForm())};
        Url url = GoogleOAuthCredentialsAcquirer.Companion.getTOKEN_URI().addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"TOKEN_URI.addParameters(\u2026Url.toExternalForm()\n  ))");
        return url;
    }

    private final GoogleCredentials getCredentials(String responseBody, HttpHeaders responseHeaders) {
        String string = responseHeaders.firstValue("date").get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"responseHeaders.firstValue(\"date\").get()");
        Date responseDateTime = GoogleOAuthService.Companion.getLocalDateTime(string);
        ObjectMapper $this$getCredentials_u24lambda_u240 = GoogleOAuthService.Companion.getJacksonMapper();
        boolean bl = false;
        $this$getCredentials_u24lambda_u240.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
        AuthorizationResponseData responseData = (AuthorizationResponseData)$this$getCredentials_u24lambda_u240.readValue(responseBody, AuthorizationResponseData.class);
        String string2 = responseData.getAccessToken();
        String string3 = responseData.getRefreshToken();
        long l = responseData.getExpiresIn();
        String string4 = responseData.getTokenType();
        String string5 = responseData.getScope();
        Date date = DateUtils.addSeconds((Date)responseDateTime, (int)((int)responseData.getExpiresIn()));
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"addSeconds(responseDateT\u2026seData.expiresIn.toInt())");
        return new GoogleCredentials(string2, string3, l, string4, string5, date);
    }

    public static final /* synthetic */ GoogleCredentials access$getCredentials(GoogleOAuthCredentialsAcquirer $this, String responseBody, HttpHeaders responseHeaders) {
        return $this.getCredentials(responseBody, responseHeaders);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthCredentialsAcquirer$AuthorizationResponseData;", "", "accessToken", "", "refreshToken", "expiresIn", "", "tokenType", "scope", "idToken", "(Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "getExpiresIn", "()J", "getIdToken", "getRefreshToken", "getScope", "getTokenType", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown.core"})
    private static final class AuthorizationResponseData {
        @NotNull
        private final String accessToken;
        @NotNull
        private final String refreshToken;
        private final long expiresIn;
        @NotNull
        private final String tokenType;
        @NotNull
        private final String scope;
        @NotNull
        private final String idToken;

        public AuthorizationResponseData(@NotNull String accessToken, @NotNull String refreshToken, long expiresIn, @NotNull String tokenType, @NotNull String scope, @NotNull String idToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.expiresIn = expiresIn;
            this.tokenType = tokenType;
            this.scope = scope;
            this.idToken = idToken;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        @NotNull
        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final long getExpiresIn() {
            return this.expiresIn;
        }

        @NotNull
        public final String getTokenType() {
            return this.tokenType;
        }

        @NotNull
        public final String getScope() {
            return this.scope;
        }

        @NotNull
        public final String getIdToken() {
            return this.idToken;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        @NotNull
        public final String component2() {
            return this.refreshToken;
        }

        public final long component3() {
            return this.expiresIn;
        }

        @NotNull
        public final String component4() {
            return this.tokenType;
        }

        @NotNull
        public final String component5() {
            return this.scope;
        }

        @NotNull
        public final String component6() {
            return this.idToken;
        }

        @NotNull
        public final AuthorizationResponseData copy(@NotNull String accessToken, @NotNull String refreshToken, long expiresIn, @NotNull String tokenType, @NotNull String scope, @NotNull String idToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            return new AuthorizationResponseData(accessToken, refreshToken, expiresIn, tokenType, scope, idToken);
        }

        public static /* synthetic */ AuthorizationResponseData copy$default(AuthorizationResponseData authorizationResponseData, String string, String string2, long l, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = authorizationResponseData.accessToken;
            }
            if ((n & 2) != 0) {
                string2 = authorizationResponseData.refreshToken;
            }
            if ((n & 4) != 0) {
                l = authorizationResponseData.expiresIn;
            }
            if ((n & 8) != 0) {
                string3 = authorizationResponseData.tokenType;
            }
            if ((n & 0x10) != 0) {
                string4 = authorizationResponseData.scope;
            }
            if ((n & 0x20) != 0) {
                string5 = authorizationResponseData.idToken;
            }
            return authorizationResponseData.copy(string, string2, l, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "AuthorizationResponseData(accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", expiresIn=" + this.expiresIn + ", tokenType=" + this.tokenType + ", scope=" + this.scope + ", idToken=" + this.idToken + ")";
        }

        public int hashCode() {
            int result2 = this.accessToken.hashCode();
            result2 = result2 * 31 + this.refreshToken.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.expiresIn);
            result2 = result2 * 31 + this.tokenType.hashCode();
            result2 = result2 * 31 + this.scope.hashCode();
            result2 = result2 * 31 + this.idToken.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthorizationResponseData)) {
                return false;
            }
            AuthorizationResponseData authorizationResponseData = (AuthorizationResponseData)other;
            if (!Intrinsics.areEqual((Object)this.accessToken, (Object)authorizationResponseData.accessToken)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshToken, (Object)authorizationResponseData.refreshToken)) {
                return false;
            }
            if (this.expiresIn != authorizationResponseData.expiresIn) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tokenType, (Object)authorizationResponseData.tokenType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scope, (Object)authorizationResponseData.scope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.idToken, (Object)authorizationResponseData.idToken);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthCredentialsAcquirer$Companion;", "", "()V", "TOKEN_URI", "Lcom/intellij/util/Url;", "getTOKEN_URI", "()Lcom/intellij/util/Url;", "authGrantType", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final Url getTOKEN_URI() {
            return Urls.newFromEncoded((String)"https://oauth2.googleapis.com/token");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

