/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.baseline;

import com.jetbrains.qodana.sarif.model.ArtifactContent;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.LogicalLocation;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.Result;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ResultKey {
    private final Result result;

    public ResultKey(Result r) {
        this.result = r;
    }

    public Result getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this.result == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultKey key = (ResultKey)o;
        Result oResult = key.result;
        if (!(Objects.equals(this.result.getMessage(), oResult.getMessage()) && Objects.equals(this.result.getRuleId(), oResult.getRuleId()) && Objects.equals((Object)this.result.getLevel(), (Object)oResult.getLevel()))) {
            return false;
        }
        List<Location> locations = this.result.getLocations();
        List<Location> oLocations = oResult.getLocations();
        if (locations == null) {
            return oLocations == null;
        }
        if (oLocations == null) {
            return false;
        }
        if (locations.size() != oLocations.size()) {
            return false;
        }
        Iterator<Location> iterator = locations.iterator();
        Iterator<Location> oIterator = oLocations.iterator();
        while (iterator.hasNext()) {
            Location oLocation;
            Location location = iterator.next();
            if (this.equalsLocation(location, oLocation = oIterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean equalsLocation(Location location, Location oLocation) {
        if (location == null || oLocation == null) {
            return location == oLocation;
        }
        if (!this.equalsPhysicalLocation(location.getPhysicalLocation(), oLocation.getPhysicalLocation())) {
            return false;
        }
        Set<LogicalLocation> locations = location.getLogicalLocations();
        Set<LogicalLocation> oLocations = oLocation.getLogicalLocations();
        if (locations == null || oLocations == null) {
            return locations == oLocations;
        }
        if (locations.size() != oLocations.size()) {
            return false;
        }
        Iterator<LogicalLocation> iterator = locations.iterator();
        Iterator<LogicalLocation> oIterator = oLocations.iterator();
        while (iterator.hasNext()) {
            LogicalLocation oLogicalLocation;
            LogicalLocation logicalLocation = iterator.next();
            if (this.equalsLogicalLocation(logicalLocation, oLogicalLocation = oIterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean equalsLogicalLocation(LogicalLocation location, LogicalLocation oLocation) {
        if (location == null || oLocation == null) {
            return location == oLocation;
        }
        return Objects.equals(location.getName(), oLocation.getName()) && Objects.equals(location.getKind(), oLocation.getKind());
    }

    private boolean equalsPhysicalLocation(PhysicalLocation location, PhysicalLocation oLocation) {
        if (location == null || oLocation == null) {
            return location == oLocation;
        }
        return this.equalsArtifactLocation(location.getArtifactLocation(), oLocation.getArtifactLocation()) && this.equalsRegion(location.getRegion(), oLocation.getRegion());
    }

    private boolean equalsRegion(Region region, Region oRegion) {
        if (region == null || oRegion == null) {
            return region == oRegion;
        }
        return Objects.equals(region.getCharLength(), oRegion.getCharLength()) && Objects.equals(region.getSnippet(), oRegion.getSnippet());
    }

    private boolean equalsArtifactLocation(ArtifactLocation artifactLocation, ArtifactLocation oArtifactLocation) {
        if (artifactLocation == null || oArtifactLocation == null) {
            return artifactLocation == oArtifactLocation;
        }
        return Objects.equals(artifactLocation.getUriBaseId(), oArtifactLocation.getUriBaseId()) && Objects.equals(artifactLocation.getUri(), oArtifactLocation.getUri());
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.result.getRuleId() == null ? 0 : this.result.getRuleId().hashCode());
        hash = hash * 31 + (this.result.getMessage() == null ? 0 : this.result.getMessage().hashCode());
        hash = hash * 31 + (this.result.getLevel() == null ? 0 : this.result.getLevel().hashCode());
        if (this.result.getLocations() == null) {
            return hash;
        }
        for (Location location : this.result.getLocations()) {
            hash = hash * 31 + this.hashPhysicalLocation(location.getPhysicalLocation());
            Set<LogicalLocation> logicalLocations = location.getLogicalLocations();
            if (logicalLocations == null) continue;
            for (LogicalLocation logicalLocation : logicalLocations) {
                hash = hash * 31 + this.hashLogicalLocation(logicalLocation);
            }
        }
        return hash;
    }

    public int hashPhysicalLocation(PhysicalLocation location) {
        if (location == null) {
            return 0;
        }
        int hash = 1;
        ArtifactLocation artifactLocation = location.getArtifactLocation();
        if (artifactLocation != null) {
            hash = hash * 31 + (artifactLocation.getUri() == null ? 0 : artifactLocation.getUri().hashCode());
            hash = hash * 31 + (artifactLocation.getUriBaseId() == null ? 0 : artifactLocation.getUriBaseId().hashCode());
        }
        hash = hash * 31 + this.hashRegion(location.getRegion());
        return hash;
    }

    public int hashLogicalLocation(LogicalLocation location) {
        if (location == null) {
            return 0;
        }
        int hash = 1;
        hash = hash * 31 + (location.getName() == null ? 0 : location.getName().hashCode());
        hash = hash * 31 + (location.getKind() == null ? 0 : location.getKind().hashCode());
        return hash;
    }

    public int hashRegion(Region region) {
        if (region == null) {
            return 0;
        }
        int hash = 1;
        hash = hash * 31 + (region.getCharLength() == null ? 0 : region.getCharLength());
        ArtifactContent snippet = region.getSnippet();
        if (snippet != null) {
            hash = hash * 31 + (snippet.getText() == null ? 0 : snippet.getText().hashCode());
        }
        return hash;
    }
}

