/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.java;

import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkLookup;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfigKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/jvm/java/JdkConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator;", "()V", "getDescription", "", "getName", "preConfigureProject", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "JdkConfig", "intellij.qodana.jvm.java"})
public final class JdkConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "qodanaProjectJdkConfigurator";
    }

    @NotNull
    public String getDescription() {
        String string = QodanaBundle.message("progress.message.qodana.jdk.configuring", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"progress.message.qodana.jdk.configuring\")");
        return string;
    }

    public void preConfigureProject(@NotNull Project project2, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path path = context.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"context.projectPath");
        JdkConfig config = QodanaConfigKt.readQodanaConfig(path, JdkConfig.class, new JdkConfig(null, 1, null));
        if (((CharSequence)config.getProjectJDK()).length() == 0) {
            return;
        }
        CompletableFuture<Sdk> future = new CompletableFuture<Sdk>();
        SdkLookupBuilder sdkLookupBuilder = SdkLookup.Companion.newLookupBuilder();
        ProgressIndicator progressIndicator = context.getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"context.progressIndicator");
        SdkLookupBuilder sdkLookupBuilder2 = sdkLookupBuilder.withProgressIndicator(progressIndicator).withSdkName(config.getProjectJDK());
        JavaSdk javaSdk = JavaSdk.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)javaSdk, (String)"getInstance()");
        sdkLookupBuilder2.withSdkType((SdkType)javaSdk).onSdkResolved((Function1)new Function1<Sdk, Unit>(future, project2){
            final /* synthetic */ CompletableFuture<Sdk> $future;
            final /* synthetic */ Project $project;
            {
                this.$future = $future;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@Nullable Sdk sdk) {
                if (sdk != null) {
                    ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(this.$project, sdk){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ Sdk $sdk;
                        {
                            this.$project = $project;
                            this.$sdk = $sdk;
                            super(0);
                        }

                        public final void invoke() {
                            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$project, this.$sdk){
                                final /* synthetic */ Project $project;
                                final /* synthetic */ Sdk $sdk;
                                {
                                    this.$project = $project;
                                    this.$sdk = $sdk;
                                    super(0);
                                }

                                public final void invoke() {
                                    ProjectRootManager.getInstance((Project)this.$project).setProjectSdk(this.$sdk);
                                }
                            }));
                        }
                    }), (int)1, null);
                }
                this.$future.complete(sdk);
            }
        }).executeLookup();
        Sdk sdk = future.get();
        if (sdk == null) {
            throw new QodanaException("Can't find locally or download required in config JDK '" + config.getProjectJDK() + "'");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/jvm/java/JdkConfigurator$JdkConfig;", "", "projectJDK", "", "(Ljava/lang/String;)V", "getProjectJDK", "()Ljava/lang/String;", "setProjectJDK", "intellij.qodana.jvm.java"})
    public static final class JdkConfig {
        @NotNull
        private String projectJDK;

        public JdkConfig(@NotNull String projectJDK) {
            Intrinsics.checkNotNullParameter((Object)projectJDK, (String)"projectJDK");
            this.projectJDK = projectJDK;
        }

        public /* synthetic */ JdkConfig(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            this(string);
        }

        @NotNull
        public final String getProjectJDK() {
            return this.projectJDK;
        }

        public final void setProjectJDK(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.projectJDK = string;
        }

        public JdkConfig() {
            this(null, 1, null);
        }
    }
}

