/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.ContentManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaProblemConsumer;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaToolResultDatabase;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.RuntimeNotifications;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.externalTools.ExternalInspectionToolWrapper;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.externalTools.ExternalToolsConfigurationProvider;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.externalTools.ExternalToolsProvider;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaProfile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJP\u0010*\u001a\u00020+2\u000e\u0010,\u001a\n\u0012\u0006\b\u0000\u0012\u00020.0-2\u000e\u0010/\u001a\n\u0012\u0006\b\u0000\u0012\u00020.0-2\u000e\u00100\u001a\n\u0012\u0006\b\u0000\u0012\u00020.0-2\u0006\u00101\u001a\u00020.2\u000e\u00102\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000303H\u0014J\u0006\u00104\u001a\u00020+J\b\u00105\u001a\u00020\nH\u0016J8\u00106\u001a\u0002072\u000e\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-2\u000e\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020+H\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006?"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl;", "project", "Lcom/intellij/openapi/project/Project;", "contentManager", "Lcom/intellij/openapi/util/NotNullLazyValue;", "Lcom/intellij/ui/content/ContentManager;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "outputPath", "Ljava/nio/file/Path;", "profile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile;", "inspectionJob", "Lkotlinx/coroutines/Job;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/NotNullLazyValue;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;Ljava/nio/file/Path;Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile;Lkotlinx/coroutines/Job;)V", "getConfig", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "consumer", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaProblemConsumer;", "getConsumer", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaProblemConsumer;", "database", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase;", "getDatabase", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase;", "effectiveProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "getEffectiveProfile", "()Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "getInspectionJob", "()Lkotlinx/coroutines/Job;", "getProfile", "()Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile;", "profileState", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;", "getProfileState", "()Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;", "runtimeNotifications", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/RuntimeNotifications;", "getRuntimeNotifications", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/RuntimeNotifications;", "classifyTool", "", "outGlobalTools", "", "Lcom/intellij/codeInspection/ex/Tools;", "outLocalTools", "outGlobalSimpleTools", "currentTools", "toolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "closeQodanaContext", "getOutputPath", "getWrappersFromTools", "Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl$Wrappers;", "localTools", "globalSimpleTools", "file", "Lcom/intellij/psi/PsiFile;", "includeDoNotShow", "", "runExternalTools", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaGlobalInspectionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaGlobalInspectionContext.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,85:1\n819#2:86\n847#2,2:87\n819#2:89\n847#2,2:90\n819#2:92\n847#2,2:93\n1295#3,2:95\n*S KotlinDebug\n*F\n+ 1 QodanaGlobalInspectionContext.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext\n*L\n52#1:86\n52#1:87,2\n53#1:89\n53#1:90,2\n54#1:92\n54#1:93,2\n62#1:95,2\n*E\n"})
public final class QodanaGlobalInspectionContext
extends GlobalInspectionContextImpl {
    @NotNull
    private final QodanaConfig config;
    @NotNull
    private final Path outputPath;
    @NotNull
    private final QodanaProfile profile;
    @NotNull
    private final Job inspectionJob;
    @NotNull
    private final QodanaProfile.QodanaProfileState profileState;
    @NotNull
    private final QodanaInspectionProfile effectiveProfile;
    @NotNull
    private final QodanaToolResultDatabase database;
    @NotNull
    private final QodanaProblemConsumer consumer;
    @NotNull
    private final RuntimeNotifications runtimeNotifications;

    public QodanaGlobalInspectionContext(@NotNull Project project2, @NotNull NotNullLazyValue<? extends ContentManager> contentManager, @NotNull QodanaConfig config, @NotNull Path outputPath, @NotNull QodanaProfile profile2, @NotNull Job inspectionJob) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(contentManager, (String)"contentManager");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)inspectionJob, (String)"inspectionJob");
        super(project2, contentManager);
        this.config = config;
        this.outputPath = outputPath;
        this.profile = profile2;
        this.inspectionJob = inspectionJob;
        this.profileState = this.profile.createState(this);
        this.effectiveProfile = this.profile.getEffectiveProfile();
        this.database = QodanaToolResultDatabase.Companion.create(this.outputPath);
        this.consumer = new QodanaProblemConsumer(project2, this.database, this.profileState);
        this.runtimeNotifications = new RuntimeNotifications();
        this.setProblemConsumer(this.consumer);
        this.setExternalProfile(this.effectiveProfile);
        this.myViewClosed = false;
    }

    @NotNull
    public final QodanaConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final QodanaProfile getProfile() {
        return this.profile;
    }

    @NotNull
    public final Job getInspectionJob() {
        return this.inspectionJob;
    }

    @NotNull
    public Path getOutputPath() {
        return this.outputPath;
    }

    @NotNull
    public final QodanaProfile.QodanaProfileState getProfileState() {
        return this.profileState;
    }

    @NotNull
    public final QodanaInspectionProfile getEffectiveProfile() {
        return this.effectiveProfile;
    }

    @NotNull
    public final QodanaToolResultDatabase getDatabase() {
        return this.database;
    }

    @NotNull
    public final QodanaProblemConsumer getConsumer() {
        return this.consumer;
    }

    @NotNull
    public final RuntimeNotifications getRuntimeNotifications() {
        return this.runtimeNotifications;
    }

    @NotNull
    public GlobalInspectionContextImpl.Wrappers getWrappersFromTools(@NotNull List<? extends Tools> localTools, @NotNull List<? extends Tools> globalSimpleTools, @NotNull PsiFile file, boolean includeDoNotShow) {
        List list2;
        LocalInspectionToolWrapper it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(localTools, (String)"localTools");
        Intrinsics.checkNotNullParameter(globalSimpleTools, (String)"globalSimpleTools");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GlobalInspectionContextImpl.Wrappers wrappers = super.getWrappersFromTools(localTools, globalSimpleTools, file, includeDoNotShow);
        List list3 = wrappers.getLocalWrappers();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"wrappers.localWrappers");
        Iterable $this$filterNot$iv = list3;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (LocalInspectionToolWrapper)element$iv$iv;
            boolean bl = false;
            String string = it.getShortName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.shortName");
            Intrinsics.checkNotNullExpressionValue((Object)wrappers, (String)"wrappers");
            if (this.profileState.shouldSkip(string, file, wrappers)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list4 = (List)destination$iv$iv;
        List list5 = wrappers.getGlobalSimpleWrappers();
        Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"wrappers.globalSimpleWrappers");
        $this$filterNot$iv = list5;
        List list6 = list4;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (GlobalInspectionToolWrapper)element$iv$iv;
            boolean bl = false;
            String string = it.getShortName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.shortName");
            Intrinsics.checkNotNullExpressionValue((Object)wrappers, (String)"wrappers");
            if (this.profileState.shouldSkip(string, file, wrappers)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list7 = wrappers.getExternalAnnotatorWrappers();
        Intrinsics.checkNotNullExpressionValue((Object)list7, (String)"wrappers.externalAnnotatorWrappers");
        $this$filterNot$iv = list7;
        List list8 = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (InspectionToolWrapper)element$iv$iv;
            boolean bl = false;
            String string = it.getShortName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.shortName");
            Intrinsics.checkNotNullExpressionValue((Object)wrappers, (String)"wrappers");
            if (this.profileState.shouldSkip(string, file, wrappers)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list9 = list2 = (List)destination$iv$iv;
        List list10 = list8;
        List list11 = list6;
        return new GlobalInspectionContextImpl.Wrappers(list11, list10, list9);
    }

    protected void runExternalTools() {
        JobDescriptor[][] jobDescriptorArrayArray = new JobDescriptor[][]{ExternalToolsConfigurationProvider.Companion.runAnnounceJobDescriptors(this), ExternalToolsProvider.Companion.runAnnounceJobDescriptors(this)};
        Sequence $this$forEach$iv = SequencesKt.flatMapIterable((Sequence)SequencesKt.sequenceOf((Object[])((Object[])jobDescriptorArrayArray)), (Function1)runExternalTools.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JobDescriptor it = (JobDescriptor)element$iv;
            boolean bl = false;
            this.appendJobDescriptor(it);
        }
        InspectListener inspectListener = this.getEventPublisher();
        Intrinsics.checkNotNullExpressionValue((Object)inspectListener, (String)"eventPublisher");
        ExternalToolsConfigurationProvider.Companion.runPreRunActivities(this, inspectListener);
        ExternalToolsProvider.Companion.runExternalToolsProviders(this, this.getEventPublisher());
        ExternalToolsConfigurationProvider.Companion.runPostRunActivities(this);
    }

    protected void classifyTool(@NotNull List<? super Tools> outGlobalTools, @NotNull List<? super Tools> outLocalTools, @NotNull List<? super Tools> outGlobalSimpleTools, @NotNull Tools currentTools, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        Intrinsics.checkNotNullParameter(outGlobalTools, (String)"outGlobalTools");
        Intrinsics.checkNotNullParameter(outLocalTools, (String)"outLocalTools");
        Intrinsics.checkNotNullParameter(outGlobalSimpleTools, (String)"outGlobalSimpleTools");
        Intrinsics.checkNotNullParameter((Object)currentTools, (String)"currentTools");
        Intrinsics.checkNotNullParameter(toolWrapper, (String)"toolWrapper");
        if (toolWrapper instanceof ExternalInspectionToolWrapper) {
            return;
        }
        super.classifyTool(outGlobalTools, outLocalTools, outGlobalSimpleTools, currentTools, toolWrapper);
    }

    public final void closeQodanaContext() {
        this.consumer.close();
        this.profileState.onFinish();
        this.profileState.dump();
        this.database.close();
    }
}

