/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner.globalOutput;

import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.VersionedMap;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.Problem;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaToolResultDatabase;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.globalOutput.DuplicateCodeConsumerKt;
import org.jetbrains.qodana.staticAnalysis.sarif.CommonDescriptor;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/globalOutput/DuplicatesProblem;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/Problem;", "element", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "getElement", "()Lorg/jdom/Element;", "getFile", "", "getModule", "getSarif", "Lcom/jetbrains/qodana/sarif/model/Result;", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "database", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nDuplicateCodeConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateCodeConsumer.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/globalOutput/DuplicatesProblem\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n8#2:139\n8#2:140\n1#3:141\n*S KotlinDebug\n*F\n+ 1 DuplicateCodeConsumer.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/globalOutput/DuplicatesProblem\n*L\n103#1:139\n107#1:140\n*E\n"})
final class DuplicatesProblem
implements Problem {
    @NotNull
    private final Element element;

    public DuplicatesProblem(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.element = element2;
    }

    @NotNull
    public final Element getElement() {
        return this.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Result getSarif(@NotNull PathMacroManager macroManager, @NotNull QodanaToolResultDatabase database) {
        void $this$getSarif_u24lambda_u241;
        Object file;
        Intrinsics.checkNotNullParameter((Object)macroManager, (String)"macroManager");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        macroManager.collapsePathsRecursively(this.element);
        Result mainResult = null;
        List locs = new ArrayList();
        for (Element fragment : this.element.getChildren("fragment")) {
            file = fragment.getAttributeValue("file");
            int line = Integer.parseInt(fragment.getAttributeValue("line"));
            int start = Integer.parseInt(fragment.getAttributeValue("start"));
            int end = Integer.parseInt(fragment.getAttributeValue("end"));
            int length = end - start;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            AutoCloseable autoCloseable = database.selectDuplicate((String)file, line, start);
            Throwable throwable = null;
            try {
                Location location;
                DuplicatesProblem $this$thisLogger$iv;
                QodanaToolResultDatabase.StringColumnClosableQuery query = (QodanaToolResultDatabase.StringColumnClosableQuery)autoCloseable;
                boolean bl = false;
                List jsons = SequencesKt.toList(query.executeQuery());
                String json2 = (String)CollectionsKt.firstOrNull((List)jsons);
                String problemLocation = (String)file + ":" + line + ":" + start;
                if (json2 == null) {
                    $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger2 = Logger.getInstance(DuplicatesProblem.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                    logger2.warn("Can't find duplicate problem in db, " + problemLocation);
                    Result result = null;
                    return result;
                }
                if (jsons.size() > 1) {
                    $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger3 = Logger.getInstance(DuplicatesProblem.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(T::class.java)");
                    logger3.warn(jsons.size() + " duplicates of duplicate problem found, " + problemLocation);
                }
                Result result = (Result)DuplicateCodeConsumerKt.access$getGson$p().fromJson(json2, Result.class);
                Result result2 = mainResult;
                if (result2 == null) {
                    result2 = result;
                }
                mainResult = result2;
                List<Location> list2 = result.getLocations();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"result.locations");
                if ((Location)CollectionsKt.getOrNull(list2, (int)0) == null) {
                    Result result3 = null;
                    return result3;
                }
                Location location2 = location;
                Location location3 = location2.withPhysicalLocation(SarifKt.getPhysicalLocation(new CommonDescriptor((String)file, line, location2.getPhysicalLocation().getRegion().getStartColumn() - 1, length, location2.getPhysicalLocation().getContextRegion().getSnippet().getText(), location2.getPhysicalLocation().getRegion().getSourceLanguage()), macroManager, 0));
                Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"location.withPhysicalLoc\u2026           0)\n          )");
                boolean bl2 = locs.add(location3);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        Result result = mainResult;
        if (result == null) {
            return null;
        }
        Result sarif = result;
        VersionedMap<String> versionedMap = new VersionedMap<String>();
        file = versionedMap;
        Result result4 = sarif.withLocations(locs);
        boolean bl = false;
        $this$getSarif_u24lambda_u241.put("equalIndicator", 1, SarifKt.calcHash(sarif));
        return result4.withPartialFingerprints(versionedMap);
    }

    @Override
    @Nullable
    public String getFile() {
        return null;
    }

    @Override
    @Nullable
    public String getModule() {
        return null;
    }
}

