/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.profile.ProblemCounters;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\tR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/Thresholds;", "", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;)V", "problemCounters", "", "", "Lorg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addProblem", "", "inspectionId", "relativePath", "module", "constructNotifications", "", "constructServiceMessages", "Lorg/jdom/Element;", "isReached", "", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nSanityInspectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/Thresholds\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,232:1\n1179#2,2:233\n1253#2,4:235\n125#3:239\n152#3,3:240\n125#3:250\n152#3,3:251\n515#4:243\n500#4,6:244\n*S KotlinDebug\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/Thresholds\n*L\n74#1:233,2\n74#1:235,4\n90#1:239\n90#1:240,3\n98#1:250\n98#1:251,3\n97#1:243\n97#1:244,6\n*E\n"})
final class Thresholds {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, ProblemCounters> problemCounters;

    /*
     * WARNING - void declaration
     */
    public Thresholds(@NotNull Project project2, @NotNull QodanaConfig config) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.project = project2;
        Iterable iterable = InspectionToolRegistrar.Companion.getInstance().createTools();
        Thresholds thresholds = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            InspectionToolWrapper it = (InspectionToolWrapper)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getShortName(), (Object)new ProblemCounters(config, this.project, it));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        thresholds.problemCounters = destination$iv$iv;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void addProblem(@NotNull String inspectionId, @Nullable String relativePath, @Nullable String module2) {
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        ProblemCounters problemCounters = this.problemCounters.get(inspectionId);
        if (problemCounters == null) {
            return;
        }
        ProblemCounters problemCounters2 = problemCounters;
        problemCounters2.addProblem(relativePath, module2);
    }

    public final boolean isReached(@NotNull String inspectionId, @Nullable String relativePath, @Nullable String module2) {
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        ProblemCounters problemCounters = this.problemCounters.get(inspectionId);
        if (problemCounters == null) {
            return false;
        }
        ProblemCounters problemCounters2 = problemCounters;
        return problemCounters2.isThresholdReached(relativePath, module2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Element> constructServiceMessages() {
        void $this$mapTo$iv$iv;
        Map<String, ProblemCounters> $this$map$iv = this.problemCounters;
        boolean $i$f$map = false;
        Map<String, ProblemCounters> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String id = (String)entry.getKey();
            ProblemCounters counters = (ProblemCounters)entry.getValue();
            collection.add(counters.constructServiceMessages(id));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> constructNotifications() {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Map<String, ProblemCounters> $this$filter$iv = this.problemCounters;
        boolean $i$f$filter = false;
        Map<String, ProblemCounters> map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((ProblemCounters)it.getValue()).wasAnyThresholdReached()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add("\"" + ((ProblemCounters)it.getValue()).getInspectionToolWrapper().getDisplayName() + "\"");
        }
        String skippedInspections = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        Object[] objectArray = new Object[]{skippedInspections};
        String string = QodanaBundle.message("sanity.suspend.inspection.notification.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"sanity.suspend.\u2026age\", skippedInspections)");
        return CollectionsKt.listOf((Object)string);
    }
}

