/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile.providers;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.inspectionProfile.YamlInspectionProfileImpl;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileManager;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileProvider;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaToolRegistrar;
import org.jetbrains.qodana.staticAnalysis.profile.providers.QodanaEmbeddedProfile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/providers/QodanaEmbeddedProfilesProvider;", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfileProvider;", "()V", "createResourceStream", "Ljava/io/InputStream;", "profileFilename", "", "getAllProfileNames", "", "project", "Lcom/intellij/openapi/project/Project;", "getInputStreamForProfile", "embeddedProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/providers/QodanaEmbeddedProfile;", "getProfileResourceName", "isJsNeededByDefault", "", "provideProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "profileName", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaEmbeddedProfilesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaEmbeddedProfilesProvider.kt\norg/jetbrains/qodana/staticAnalysis/profile/providers/QodanaEmbeddedProfilesProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1282#2,2:90\n3792#2:92\n4307#2,2:93\n1549#3:95\n1620#3,3:96\n*S KotlinDebug\n*F\n+ 1 QodanaEmbeddedProfilesProvider.kt\norg/jetbrains/qodana/staticAnalysis/profile/providers/QodanaEmbeddedProfilesProvider\n*L\n29#1:90,2\n50#1:92\n50#1:93,2\n50#1:95\n50#1:96,3\n*E\n"})
public final class QodanaEmbeddedProfilesProvider
implements QodanaInspectionProfileProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public QodanaInspectionProfile provideProfile(@NotNull String profileName, @Nullable Project project2) {
        QodanaEmbeddedProfile qodanaEmbeddedProfile;
        block9: {
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            QodanaEmbeddedProfile[] $this$firstOrNull$iv = QodanaEmbeddedProfile.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                QodanaEmbeddedProfile element$iv;
                QodanaEmbeddedProfile it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!it.matchesName(profileName)) continue;
                qodanaEmbeddedProfile = element$iv;
                break block9;
            }
            qodanaEmbeddedProfile = null;
        }
        if (qodanaEmbeddedProfile == null) {
            return null;
        }
        QodanaEmbeddedProfile embeddedProfile = qodanaEmbeddedProfile;
        QodanaInspectionProfileManager profileManager = QodanaInspectionProfileManager.Companion.getInstance(project2);
        Closeable closeable = this.getInputStreamForProfile(embeddedProfile);
        Throwable throwable = null;
        try {
            InputStream profileStream = (InputStream)closeable;
            boolean bl = false;
            if (embeddedProfile.isYaml()) {
                InspectionProfileImpl yamlProfile2 = YamlInspectionProfileImpl.Companion.loadFrom((Reader)new InputStreamReader(profileStream), (Function1)new Function1<Path, Reader>(this){
                    final /* synthetic */ QodanaEmbeddedProfilesProvider this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Reader invoke(@NotNull Path path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        return new InputStreamReader(QodanaEmbeddedProfilesProvider.access$createResourceStream(this.this$0, ((Object)path).toString()));
                    }
                }, (InspectionToolsSupplier)QodanaToolRegistrar.Companion.getInstance(), (BaseInspectionProfileManager)profileManager).buildEffectiveProfile();
                String string = yamlProfile2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"yamlProfile.name");
                QodanaInspectionProfile qodanaInspectionProfile2 = QodanaInspectionProfile.Companion.clone(yamlProfile2, string, profileManager);
                return qodanaInspectionProfile2;
            }
            Element element2 = JDOMUtil.load((InputStream)profileStream);
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
            QodanaInspectionProfile qodanaInspectionProfile3 = QodanaInspectionProfile.Companion.newFromXml(element2, embeddedProfile.getProfileName(), profileManager);
            return qodanaInspectionProfile3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getAllProfileNames(@Nullable Project project2) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        QodanaEmbeddedProfile[] $this$filter$iv = QodanaEmbeddedProfile.values();
        boolean $i$f$filter = false;
        QodanaEmbeddedProfile[] qodanaEmbeddedProfileArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (QodanaEmbeddedProfile element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!it.isYaml()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            QodanaEmbeddedProfile element$iv$iv;
            element$iv$iv = (QodanaEmbeddedProfile)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProfileName());
        }
        return (List)destination$iv$iv;
    }

    @VisibleForTesting
    @NotNull
    public final InputStream getInputStreamForProfile(@NotNull QodanaEmbeddedProfile embeddedProfile) {
        Intrinsics.checkNotNullParameter((Object)((Object)embeddedProfile), (String)"embeddedProfile");
        String profileFilename = this.getProfileResourceName(embeddedProfile);
        return this.createResourceStream(profileFilename);
    }

    private final String getProfileResourceName(QodanaEmbeddedProfile embeddedProfile) {
        return switch (WhenMappings.$EnumSwitchMapping$0[embeddedProfile.ordinal()]) {
            case 1 -> "qodana.recommended.full.xml";
            case 2 -> "qodana.starter.full.xml";
            case 3 -> "qodana.sanity.yaml";
            case 4 -> {
                String var2_2 = System.getProperty("qodana.starter.profile.resource");
                if (var2_2 == null) {
                    if (this.isJsNeededByDefault()) {
                        yield "qodana-js.starter.yaml";
                    }
                    yield "qodana.starter.yaml";
                }
                yield var2_2;
            }
            case 5 -> {
                String var2_3 = System.getProperty("qodana.recommended.profile.resource");
                if (var2_3 == null) {
                    if (this.isJsNeededByDefault()) {
                        yield "qodana-js.recommended.yaml";
                    }
                    yield "qodana.recommended.yaml";
                }
                yield var2_3;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isJsNeededByDefault() {
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().build.productCode");
        String productCode = string;
        return Intrinsics.areEqual((Object)productCode, (Object)"WS") || Intrinsics.areEqual((Object)productCode, (Object)"PS");
    }

    private final InputStream createResourceStream(String profileFilename) {
        InputStream inputStream = this.getClass().getResourceAsStream("/qodana-profiles/.idea/inspectionProfiles/" + profileFilename);
        if (inputStream == null) {
            throw new QodanaException("Cannot find file profile file " + profileFilename + " in resources");
        }
        return inputStream;
    }

    public static final /* synthetic */ InputStream access$createResourceStream(QodanaEmbeddedProfilesProvider $this, String profileFilename) {
        return $this.createResourceStream(profileFilename);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QodanaEmbeddedProfile.values().length];
            try {
                nArray[QodanaEmbeddedProfile.QODANA_RECOMMENDED_OLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaEmbeddedProfile.QODANA_STARTER_OLD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaEmbeddedProfile.QODANA_SANITY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaEmbeddedProfile.QODANA_STARTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaEmbeddedProfile.QODANA_RECOMMENDED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

