/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

public class LineMapData {
    private final int mySourceStart;
    private final int myCount;
    private final int myMappedStart;
    private final int myIncrement;

    public LineMapData(int sourceStart, int count, int mappedStart, int increment) {
        this.mySourceStart = sourceStart;
        this.myCount = count;
        this.myMappedStart = mappedStart;
        this.myIncrement = increment;
    }

    public int getCount() {
        return this.myCount;
    }

    public int getSourceLine(int index) {
        this.checkIndex(index);
        return this.mySourceStart + index;
    }

    public int getMappingStart(int index) {
        this.checkIndex(index);
        return this.myMappedStart + index * this.myIncrement;
    }

    public int getMappingEnd(int index) {
        this.checkIndex(index);
        return this.myMappedStart + (index + 1) * this.myIncrement;
    }

    public String toString() {
        return "map [" + this.myMappedStart + "; " + (this.myMappedStart + this.myCount * this.myIncrement) + ") to [" + this.mySourceStart + "; " + (this.mySourceStart + this.myCount) + ")";
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.myCount) {
            throw new IllegalArgumentException("Invalid index " + index + " in mapping " + this);
        }
    }
}

