/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.CoverageTransformer;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingArrayMode;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingClassDataMode;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.CoverageReport;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.OptionsUtil;
import com.intellij.rt.coverage.util.TestTrackingCallback;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instrumentator {
    public static boolean ourIsInitialized = false;

    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        new Instrumentator().performPremain(argsString, instrumentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performPremain(String argsString, Instrumentation instrumentation) throws Exception {
        this.checkLogLevel();
        Class<Instrumentator> clazz = Instrumentator.class;
        synchronized (Instrumentator.class) {
            TestTrackingMode testTrackingMode;
            File sourceMapFile;
            String[] args;
            if (ourIsInitialized) {
                ErrorReporter.reportError("Coverage agent has been applied twice, ignore the second one.");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            ourIsInitialized = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (argsString != null) {
                File argsFile = new File(argsString);
                if (argsFile.isFile()) {
                    try {
                        args = this.readArgsFromFile(argsString);
                    }
                    catch (IOException e) {
                        ErrorReporter.reportError("Arguments were not passed correctly", e);
                        return;
                    }
                } else {
                    args = Instrumentator.tokenize(argsString);
                }
            } else {
                ErrorReporter.reportError("Argument string should be passed");
                return;
            }
            if (args.length < 5) {
                ErrorReporter.logError("At least 5 arguments expected but " + args.length + " found.\n" + '\'' + argsString + "'\nExpected arguments are:\n1) data file to save coverage result\n2) a flag to enable tracking per test coverage\n3) a flag to calculate coverage for unloaded classes\n4) a flag to use data file as initial coverage, also use it if several parallel processes are to write into one file\n5) a flag to run line coverage or branch coverage otherwise\n");
                System.exit(1);
            }
            File dataFile = new File(args[0]);
            boolean testTracking = Boolean.parseBoolean(args[1]);
            boolean calcUnloaded = Boolean.parseBoolean(args[2]);
            boolean mergeData = Boolean.parseBoolean(args[3]);
            boolean branchCoverage = !Boolean.parseBoolean(args[4]);
            ErrorReporter.setBasePath(dataFile.getParent());
            int i = 5;
            if (args.length > 5 && Boolean.parseBoolean(args[5])) {
                sourceMapFile = new File(args[6]);
                i = 7;
            } else {
                sourceMapFile = null;
            }
            ErrorReporter.logInfo("---- IntelliJ IDEA coverage runner ---- ");
            ErrorReporter.logInfo(branchCoverage ? "Branch coverage " + (testTracking ? "with tracking per test coverage ..." : "...") : "Line coverage ...");
            ArrayList<Pattern> includePatterns = new ArrayList<Pattern>();
            i = this.readPatterns(includePatterns, i, args, "include");
            ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>();
            if (i < args.length && "-exclude".equals(args[i])) {
                i = this.readPatterns(excludePatterns, i + 1, args, "exclude");
            }
            ArrayList<Pattern> annotationsToIgnore = new ArrayList<Pattern>();
            if (i < args.length && "-excludeAnnotations".equals(args[i])) {
                this.readPatterns(annotationsToIgnore, i + 1, args, "exclude annotations");
            }
            TestTrackingCallback callback = (testTrackingMode = this.createTestTrackingMode(testTracking)) == null ? null : testTrackingMode.createTestTrackingCallback();
            final ProjectData data = ProjectData.createProjectData(dataFile, null, testTracking, branchCoverage, includePatterns, excludePatterns, callback);
            data.setAnnotationsToIgnore(annotationsToIgnore);
            ClassFinder cf = new ClassFinder(includePatterns, excludePatterns);
            final CoverageReport report = new CoverageReport(dataFile, calcUnloaded, cf, mergeData);
            report.setSourceMapFile(sourceMapFile);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    report.save(data);
                }
            }));
            boolean shouldSaveSource = sourceMapFile != null;
            CoverageTransformer transformer = new CoverageTransformer(data, shouldSaveSource, excludePatterns, includePatterns, cf, testTrackingMode);
            this.addTransformer(instrumentation, transformer);
            return;
        }
    }

    private int readPatterns(List<Pattern> patterns, int i, String[] args, String name) {
        ErrorReporter.logInfo(name + " patterns:");
        while (i < args.length && !args[i].startsWith("-")) {
            try {
                patterns.add(Pattern.compile(args[i]));
                ErrorReporter.logInfo(args[i]);
            }
            catch (PatternSyntaxException ex) {
                ErrorReporter.reportError("Problem occurred with " + name + " pattern " + args[i] + ". This may cause no tests run and no coverage collected", ex);
                System.exit(1);
            }
            ++i;
        }
        return i;
    }

    private void checkLogLevel() {
        if ("error".equals(OptionsUtil.LOG_LEVEL)) {
            ErrorReporter.setLogLevel(2);
        } else {
            ErrorReporter.setLogLevel(0);
        }
    }

    private void addTransformer(Instrumentation instrumentation, CoverageTransformer transformer) {
        try {
            Method method = Instrumentation.class.getMethod("addTransformer", ClassFileTransformer.class, Boolean.TYPE);
            method.invoke((Object)instrumentation, transformer, true);
        }
        catch (NoSuchMethodException e) {
            instrumentation.addTransformer(transformer);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Adding transformer failed.", e);
            System.exit(1);
        }
    }

    private TestTrackingMode createTestTrackingMode(boolean traceLines) {
        if (!traceLines) {
            return null;
        }
        if (OptionsUtil.NEW_BRANCH_COVERAGE_ENABLED && OptionsUtil.NEW_TEST_TRACKING_ENABLED) {
            return new TestTrackingArrayMode();
        }
        return new TestTrackingClassDataMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readArgsFromFile(String arg) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File file = new File(arg);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            while (reader.ready()) {
                result.add(reader.readLine());
            }
        }
        finally {
            reader.close();
        }
        return result.toArray(new String[0]);
    }

    private static String[] tokenize(String argumentString) {
        ArrayList<String> tokenizedArgs = new ArrayList<String>();
        StringBuilder currentArg = new StringBuilder();
        block4: for (int i = 0; i < argumentString.length(); ++i) {
            char c = argumentString.charAt(i);
            switch (c) {
                default: {
                    currentArg.append(c);
                    continue block4;
                }
                case ' ': {
                    String arg = currentArg.toString();
                    if (arg.length() > 0) {
                        tokenizedArgs.add(arg);
                    }
                    currentArg = new StringBuilder();
                    continue block4;
                }
                case '\"': {
                    char d;
                    ++i;
                    while (i < argumentString.length() && (d = argumentString.charAt(i)) != '\"') {
                        currentArg.append(d);
                        ++i;
                    }
                    break block0;
                }
            }
        }
        String arg = currentArg.toString();
        if (arg.length() > 0) {
            tokenizedArgs.add(arg);
        }
        return tokenizedArgs.toArray(new String[0]);
    }
}

