/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinDefaultArgsBranchFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class KotlinOpenMemberWithDefaultArgsFilter
extends BranchesFilter {
    private int myState = 0;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinDefaultArgsBranchFilter.isApplicable(context, access, name, desc);
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        if (this.myState == 0) {
            this.myState = 1;
            return;
        }
        this.myState = 0;
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        if (this.myState == 1 && opcode == 25) {
            this.myState = 2;
            return;
        }
        this.myState = 0;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (this.myState == 2 && opcode == 198) {
            this.myState = 3;
            return;
        }
        this.myState = 0;
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        if (this.myState == 3 && opcode == 187 && "java/lang/UnsupportedOperationException".equals(type)) {
            this.myState = 4;
            return;
        }
        this.myState = 0;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (this.myState == 4 && opcode == 89) {
            this.myState = 5;
            return;
        }
        if (this.myState == 7 && opcode == 191) {
            this.myBranchData.removeLastJump();
        }
        this.myState = 0;
    }

    public void visitLdcInsn(Object value) {
        String stringValue;
        super.visitLdcInsn(value);
        if (this.myState == 5 && value instanceof String && (stringValue = (String)value).startsWith("Super calls with default arguments not supported")) {
            this.myState = 6;
            return;
        }
        this.myState = 0;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        if (this.myState == 6 && opcode == 183 && "java/lang/UnsupportedOperationException".equals(owner) && "<init>".equals(name) && "(Ljava/lang/String;)V".equals(descriptor)) {
            this.myState = 7;
            return;
        }
        this.myState = 0;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.myState = 0;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.myState = 0;
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.myState = 0;
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.myState = 0;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        super.visitFieldInsn(opcode, owner, name, descriptor);
        this.myState = 0;
    }
}

