/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.ClassListSection;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class PartlyAnalysedClassesSection
extends ClassListSection {
    protected void loadClass(DataInputStream in, ClassData classData, int version) throws IOException {
        if (classData != null) {
            classData.setFullyAnalysed(false);
        }
    }

    protected void saveClass(ClassData classData, DataOutput out, int index) throws IOException {
        if (classData != null && !classData.isFullyAnalysed()) {
            CoverageIOUtil.writeINT(out, index);
        }
    }

    public int getId() {
        return 3;
    }

    public int getVersion() {
        return 0;
    }

    public boolean isEngaged(ProjectData projectData) {
        for (ClassData classData : projectData.getClassesCollection()) {
            if (classData.isFullyAnalysed()) continue;
            return true;
        }
        return false;
    }
}

