/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class VolatileNullableLazyValue<T>
extends NullableLazyValue<T> {
    private volatile boolean myComputed;
    @Nullable
    private volatile T myValue;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected VolatileNullableLazyValue() {
    }

    @Override
    @Nullable
    public T getValue() {
        boolean computed = this.myComputed;
        T value = this.myValue;
        if (!computed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value;
                this.myComputed = true;
            }
        }
        return value;
    }

    @Override
    public boolean isComputed() {
        return this.myComputed;
    }
}

