/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.Processor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.PersistentMapBase;
import com.intellij.util.io.PersistentMapBuilder;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public final class PersistentMapInMemory<Key, Value>
implements PersistentMapBase<Key, Value> {
    private final Object myLock;
    private final ConcurrentHashMap<Key, Value> myMap;
    private final AtomicBoolean myIsClosed;
    private final DataExternalizer<Value> myValueExternalizer;

    public PersistentMapInMemory(@NotNull PersistentMapBuilder<Key, Value> builder) {
        if (builder == null) {
            PersistentMapInMemory.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myMap = new ConcurrentHashMap();
        this.myIsClosed = new AtomicBoolean(false);
        this.myValueExternalizer = builder.getValueExternalizer();
    }

    @Override
    @NotNull
    public DataExternalizer<Value> getValuesExternalizer() {
        DataExternalizer<Value> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            PersistentMapInMemory.$$$reportNull$$$0(1);
        }
        return dataExternalizer;
    }

    @NotNull
    public Object getDataAccessLock() {
        Object object = this.myLock;
        if (object == null) {
            PersistentMapInMemory.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Override
    public void closeAndDelete() {
        this.myMap.clear();
    }

    @Override
    public int keysCount() {
        return this.myMap.size();
    }

    @Override
    public void put(Key key, Value value) throws IOException {
        this.myMap.put(key, value);
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor) throws IOException {
        if (processor == null) {
            PersistentMapInMemory.$$$reportNull$$$0(3);
        }
        return this.processExistingKeys(processor);
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void markDirty() throws IOException {
    }

    @Override
    public boolean processExistingKeys(@NotNull Processor<? super Key> processor) throws IOException {
        if (processor == null) {
            PersistentMapInMemory.$$$reportNull$$$0(4);
        }
        for (Object key : this.myMap.keySet()) {
            if (processor.process(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Value get(Key key) throws IOException {
        return this.myMap.get(key);
    }

    @Override
    public boolean containsKey(Key key) throws IOException {
        return this.myMap.containsKey(key);
    }

    @Override
    public void remove(Key key) throws IOException {
        this.myMap.remove(key);
    }

    @Override
    public void force() {
    }

    @Override
    public boolean isClosed() {
        return this.myIsClosed.get();
    }

    @Override
    public void close() throws IOException {
        this.myIsClosed.set(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PersistentMapInMemory";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PersistentMapInMemory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesExternalizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataAccessLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processExistingKeys";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

