/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;

final class Subroutine {
    final LabelNode start;
    final boolean[] localsUsed;
    final List<JumpInsnNode> callers;

    Subroutine(LabelNode start, int maxLocals, JumpInsnNode caller2) {
        this.start = start;
        this.localsUsed = new boolean[maxLocals];
        this.callers = new ArrayList<JumpInsnNode>();
        this.callers.add(caller2);
    }

    Subroutine(Subroutine subroutine) {
        this.start = subroutine.start;
        this.localsUsed = (boolean[])subroutine.localsUsed.clone();
        this.callers = new ArrayList<JumpInsnNode>(subroutine.callers);
    }

    public boolean merge(Subroutine subroutine) {
        int i;
        boolean changed = false;
        for (i = 0; i < this.localsUsed.length; ++i) {
            if (!subroutine.localsUsed[i] || this.localsUsed[i]) continue;
            this.localsUsed[i] = true;
            changed = true;
        }
        if (subroutine.start == this.start) {
            for (i = 0; i < subroutine.callers.size(); ++i) {
                JumpInsnNode caller2 = subroutine.callers.get(i);
                if (this.callers.contains(caller2)) continue;
                this.callers.add(caller2);
                changed = true;
            }
        }
        return changed;
    }
}

