/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.impl;

import com.intellij.platform.runtime.repository.IncludedRuntimeModule;
import com.intellij.platform.runtime.repository.ModuleImportance;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleGroup;
import com.intellij.platform.runtime.repository.impl.IncludedRuntimeModuleImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class MainRuntimeModuleGroup
implements RuntimeModuleGroup {
    private final List<IncludedRuntimeModule> myRootModules;
    private volatile List<IncludedRuntimeModule> myIncludedModules;

    public MainRuntimeModuleGroup(@NotNull List<IncludedRuntimeModule> rootModules) {
        if (rootModules == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(0);
        }
        this.myRootModules = rootModules;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull IncludedRuntimeModule> getIncludedModules() {
        if (this.myIncludedModules == null) {
            this.myIncludedModules = this.computeIncludedModules();
        }
        List<IncludedRuntimeModule> list = this.myIncludedModules;
        if (list == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(1);
        }
        return list;
    }

    private List<IncludedRuntimeModule> computeIncludedModules() {
        ArrayList<IncludedRuntimeModule> result = new ArrayList<IncludedRuntimeModule>(this.myRootModules);
        Set<RuntimeModuleDescriptor> rootModules = this.myRootModules.stream().map(IncludedRuntimeModule::getModuleDescriptor).collect(Collectors.toSet());
        HashSet<RuntimeModuleDescriptor> visited = new HashSet<RuntimeModuleDescriptor>();
        for (IncludedRuntimeModule rootModule : this.myRootModules) {
            MainRuntimeModuleGroup.collectDependencies(rootModule.getModuleDescriptor(), rootModules, visited, result);
        }
        return result;
    }

    private static void collectDependencies(RuntimeModuleDescriptor descriptor, Set<RuntimeModuleDescriptor> rootModules, Set<RuntimeModuleDescriptor> visited, List<IncludedRuntimeModule> result) {
        for (RuntimeModuleDescriptor dependency : descriptor.getDependencies()) {
            if (!visited.add(dependency)) continue;
            if (!rootModules.contains(dependency)) {
                result.add(new IncludedRuntimeModuleImpl(dependency, ModuleImportance.SERVICE, Collections.emptySet()));
            }
            MainRuntimeModuleGroup.collectDependencies(dependency, rootModules, visited, result);
        }
    }

    public String toString() {
        return "MainRuntimeModuleGroup{rootModules=" + this.myRootModules + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/impl/MainRuntimeModuleGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/impl/MainRuntimeModuleGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

