/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization.impl;

import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.serialization.impl.ModuleXmlSerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JarFileSerializer {
    public static final String SPECIFICATION_VERSION = "0.1";
    public static final String SPECIFICATION_TITLE = "IntelliJ Runtime Module Repository";
    private static final Attributes.Name BOOTSTRAP_MODULE_ATTRIBUTE_NAME = new Attributes.Name("Bootstrap-Module-Name");
    private static final Attributes.Name BOOTSTRAP_CLASSPATH_ATTRIBUTE_NAME = new Attributes.Name("Bootstrap-Class-Path");

    @NotNull
    public static Map<String, RawRuntimeModuleDescriptor> loadFromJar(@NotNull Path jarPath) throws IOException, XMLStreamException {
        if (jarPath == null) {
            JarFileSerializer.$$$reportNull$$$0(0);
        }
        HashMap<String, RawRuntimeModuleDescriptor> rawData = new HashMap<String, RawRuntimeModuleDescriptor>();
        try (JarInputStream input = new JarInputStream(new BufferedInputStream(Files.newInputStream(jarPath, new OpenOption[0])));){
            JarEntry entry;
            Manifest manifest = input.getManifest();
            if (manifest == null) {
                throw new IOException("Manifest not found in " + jarPath);
            }
            String version = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
            if (version == null) {
                throw new IOException("'" + Attributes.Name.SPECIFICATION_VERSION.toString() + "' attribute is not specified in " + jarPath);
            }
            if (!version.equals(SPECIFICATION_VERSION)) {
                throw new IOException("'" + jarPath + "' has unsupported version '" + version + "' ('0.1' is expected)");
            }
            XMLInputFactory factory = XMLInputFactory.newDefaultFactory();
            while ((entry = input.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(".xml")) continue;
                RawRuntimeModuleDescriptor data = ModuleXmlSerializer.parseModuleXml(factory, input);
                rawData.put(data.getId(), data);
            }
        }
        HashMap<String, RawRuntimeModuleDescriptor> hashMap = rawData;
        if (hashMap == null) {
            JarFileSerializer.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    public static @NotNull String @Nullable [] loadBootstrapClasspath(@NotNull Path jarPath, @NotNull String bootstrapModuleName) throws IOException {
        if (jarPath == null) {
            JarFileSerializer.$$$reportNull$$$0(2);
        }
        if (bootstrapModuleName == null) {
            JarFileSerializer.$$$reportNull$$$0(3);
        }
        try (JarInputStream input = new JarInputStream(new BufferedInputStream(Files.newInputStream(jarPath, new OpenOption[0])));){
            Manifest manifest = input.getManifest();
            if (manifest == null) {
                String[] stringArray = null;
                return stringArray;
            }
            Attributes attributes = manifest.getMainAttributes();
            if (!SPECIFICATION_VERSION.equals(attributes.getValue(Attributes.Name.SPECIFICATION_VERSION))) {
                String[] stringArray = null;
                return stringArray;
            }
            if (!bootstrapModuleName.equals(attributes.getValue(BOOTSTRAP_MODULE_ATTRIBUTE_NAME))) {
                String[] stringArray = null;
                return stringArray;
            }
            String classpathValue = attributes.getValue(BOOTSTRAP_CLASSPATH_ATTRIBUTE_NAME);
            if (classpathValue == null) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = classpathValue.split(" ");
            return stringArray;
        }
    }

    public static void saveToJar(@NotNull Collection<RawRuntimeModuleDescriptor> descriptors, @Nullable String bootstrapModuleName, @NotNull Path jarFile, int generatorVersion) throws IOException, XMLStreamException {
        if (descriptors == null) {
            JarFileSerializer.$$$reportNull$$$0(4);
        }
        if (jarFile == null) {
            JarFileSerializer.$$$reportNull$$$0(5);
        }
        Files.createDirectories(jarFile.getParent(), new FileAttribute[0]);
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(Attributes.Name.SPECIFICATION_TITLE, SPECIFICATION_TITLE);
        attributes.put(Attributes.Name.SPECIFICATION_VERSION, SPECIFICATION_VERSION);
        attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, "0.1." + generatorVersion);
        if (bootstrapModuleName != null) {
            attributes.put(BOOTSTRAP_MODULE_ATTRIBUTE_NAME, bootstrapModuleName);
            attributes.put(BOOTSTRAP_CLASSPATH_ATTRIBUTE_NAME, JarFileSerializer.computeClasspath(descriptors, bootstrapModuleName));
        }
        try (JarOutputStream jarOutput = new JarOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(jarFile, new OpenOption[0])), manifest);){
            XMLOutputFactory factory = XMLOutputFactory.newDefaultFactory();
            for (RawRuntimeModuleDescriptor descriptor : descriptors) {
                String id = descriptor.getId();
                jarOutput.putNextEntry(new JarEntry(id + ".xml"));
                PrintWriter output = new PrintWriter(jarOutput, false, StandardCharsets.UTF_8);
                ModuleXmlSerializer.writeModuleXml(descriptor, output, factory);
                jarOutput.closeEntry();
            }
        }
    }

    private static String computeClasspath(Collection<RawRuntimeModuleDescriptor> descriptors, String moduleName) {
        LinkedHashSet<String> classpath = new LinkedHashSet<String>();
        HashMap<String, RawRuntimeModuleDescriptor> descriptorMap = new HashMap<String, RawRuntimeModuleDescriptor>();
        for (RawRuntimeModuleDescriptor descriptor : descriptors) {
            descriptorMap.put(descriptor.getId(), descriptor);
        }
        JarFileSerializer.collectClasspathEntries(moduleName, descriptorMap, new HashSet<String>(), classpath);
        return String.join((CharSequence)" ", classpath);
    }

    private static void collectClasspathEntries(String moduleName, Map<String, RawRuntimeModuleDescriptor> descriptorMap, Set<String> processedModules, Set<String> classpath) {
        if (!processedModules.add(moduleName)) {
            return;
        }
        RawRuntimeModuleDescriptor descriptor = descriptorMap.get(moduleName);
        if (descriptor == null) {
            return;
        }
        classpath.addAll(descriptor.getResourcePaths());
        for (String dependency : descriptor.getDependencies()) {
            JarFileSerializer.collectClasspathEntries(dependency, descriptorMap, processedModules, classpath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/serialization/impl/JarFileSerializer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootstrapModuleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/serialization/impl/JarFileSerializer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromJar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFromJar";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadBootstrapClasspath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveToJar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

