/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.UtilKt;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrRangeExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrYieldStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSwitchExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrPermitsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrRecordDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GrRecordUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre40;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitCaseSection", "", "caseSection", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/clauses/GrCaseSection;", "visitLiteralExpression", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteral;", "visitModifierList", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "visitPermitsClause", "permitsClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrPermitsClause;", "visitRangeExpression", "range", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrRangeExpression;", "visitRecordDefinition", "recordDefinition", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrRecordDefinition;", "visitSwitchExpression", "switchExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrSwitchExpression;", "visitYieldStatement", "yieldStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/branch/GrYieldStatement;", "Companion", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGroovyAnnotatorPre40.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyAnnotatorPre40.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre40\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class GroovyAnnotatorPre40
extends GroovyElementVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnotationHolder holder;

    public GroovyAnnotatorPre40(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @Override
    public void visitModifierList(@NotNull GrModifierList modifierList) {
        PsiElement nonSealed;
        Intrinsics.checkNotNullParameter((Object)modifierList, (String)"modifierList");
        PsiElement sealed = modifierList.getModifier("sealed");
        if (sealed != null) {
            String string = GroovyBundle.message("inspection.message.modifier.sealed.available.with.groovy.or.later", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspection.mess\u2026le.with.groovy.or.later\")");
            String string2 = GroovyBundle.message("illegal.sealed.modifier.fix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"illegal.sealed.modifier.fix\")");
            Companion.registerModifierProblem(this.holder, sealed, string, string2);
        }
        if ((nonSealed = modifierList.getModifier("non-sealed")) != null) {
            String string = GroovyBundle.message("inspection.message.modifier.nonsealed.available.with.groovy.or.later", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspection.mess\u2026le.with.groovy.or.later\")");
            String string3 = GroovyBundle.message("illegal.nonsealed.modifier.fix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"illegal.nonsealed.modifier.fix\")");
            Companion.registerModifierProblem(this.holder, nonSealed, string, string3);
        }
    }

    @Override
    public void visitPermitsClause(@NotNull GrPermitsClause permitsClause) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)permitsClause, (String)"permitsClause");
            PsiElement psiElement = permitsClause.getKeyword();
            if (psiElement == null) break block0;
            PsiElement it = psiElement;
            boolean bl = false;
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.permits.available.with.groovy.4.or.later", new Object[0])).range(it).create();
        }
    }

    @Override
    public void visitSwitchExpression(@NotNull GrSwitchExpression switchExpression) {
        Intrinsics.checkNotNullParameter((Object)switchExpression, (String)"switchExpression");
        PsiElement psiElement = switchExpression.getFirstChild();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.switch.expressions.are.available.with.groovy.4.or.later", new Object[0])).range(it).create();
        }
        super.visitSwitchExpression(switchExpression);
    }

    @Override
    public void visitCaseSection(@NotNull GrCaseSection caseSection) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)caseSection, (String)"caseSection");
        GrCaseSection $this$visitCaseSection_u24lambda_u245 = caseSection;
        boolean bl = false;
        PsiElement psiElement = $this$visitCaseSection_u24lambda_u245.getArrow();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl2 = false;
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.arrows.in.case.expressions.are.available.with.groovy.4.or.later", new Object[0])).range(it).create();
        }
        if ((object = $this$visitCaseSection_u24lambda_u245.getExpressions()) != null) {
            Object[] objectArray;
            Object[] it = objectArray = object;
            boolean bl3 = false;
            object = it.length > 1 ? objectArray : null;
            if (object != null) {
                PsiElement psiElement2;
                PsiElement psiElement3;
                it = object;
                boolean bl4 = false;
                AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.multiple.expressions.in.case.section.are.available.with.groovy.4.or.later", new Object[0]));
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                GrExpression grExpression = (GrExpression)ArraysKt.first((Object[])it);
                PsiElement psiElement4 = psiElement3 = grExpression != null ? grExpression.getParent() : null;
                if (psiElement4 == null) {
                    psiElement2 = $this$visitCaseSection_u24lambda_u245;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"it.first()?.parent ?: this");
                    psiElement2 = psiElement3;
                }
                annotationBuilder.range(psiElement2).create();
            }
        }
        super.visitCaseSection(caseSection);
    }

    @Override
    public void visitYieldStatement(@NotNull GrYieldStatement yieldStatement) {
        Intrinsics.checkNotNullParameter((Object)yieldStatement, (String)"yieldStatement");
        PsiElement it = yieldStatement.getYieldKeyword();
        boolean bl = false;
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.keyword.yield.available.with.groovy.4.or.later", new Object[0])).range(it).create();
        super.visitYieldStatement(yieldStatement);
    }

    @Override
    public void visitRangeExpression(@NotNull GrRangeExpression range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        GrRangeExpression.BoundaryType boundaryType = range.getBoundaryType();
        switch (boundaryType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[boundaryType.ordinal()]) {
            case 1: {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.left.open.ranges.are.available.in.groovy.4.or.later", new Object[0])).range((PsiElement)range).create();
                break;
            }
            case 2: {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.both.open.ranges.are.available.in.groovy.4.or.later", new Object[0])).range((PsiElement)range).create();
            }
        }
    }

    @Override
    public void visitLiteralExpression(@NotNull GrLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        super.visitLiteralExpression(literal);
        String string = literal.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"literal.text");
        if (StringsKt.startsWith$default((String)string, (String)".", (boolean)false, (int)2, null)) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.fraction.literals.without.leading.zero.are.available.in.groovy.or.later", new Object[0])).range((PsiElement)literal).create();
        }
    }

    @Override
    public void visitRecordDefinition(@NotNull GrRecordDefinition recordDefinition) {
        Intrinsics.checkNotNullParameter((Object)recordDefinition, (String)"recordDefinition");
        GrRecordUtils.forbidRecord(this.holder, recordDefinition);
        super.visitRecordDefinition(recordDefinition);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u000b\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre40$Companion;", "", "()V", "registerModifierProblem", "", "Lcom/intellij/lang/annotation/AnnotationHolder;", "modifier", "Lcom/intellij/psi/PsiElement;", "inspectionMessage", "", "Lorg/jetbrains/annotations/Nls;", "fixMessage", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerModifierProblem(@NotNull AnnotationHolder $this$registerModifierProblem, @NotNull PsiElement modifier, @NotNull String inspectionMessage, @NotNull String fixMessage) {
            Intrinsics.checkNotNullParameter((Object)$this$registerModifierProblem, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            Intrinsics.checkNotNullParameter((Object)inspectionMessage, (String)"inspectionMessage");
            Intrinsics.checkNotNullParameter((Object)fixMessage, (String)"fixMessage");
            AnnotationBuilder annotationBuilder = $this$registerModifierProblem.newAnnotation(HighlightSeverity.ERROR, inspectionMessage).range(modifier);
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"newAnnotation(HighlightS\u2026nMessage).range(modifier)");
            AnnotationBuilder builder = annotationBuilder;
            LocalQuickFix localQuickFix = new GrRemoveModifierFix(modifier.getText(), fixMessage);
            TextRange textRange = modifier.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"modifier.textRange");
            UtilKt.registerLocalFix(builder, localQuickFix, modifier, inspectionMessage, ProblemHighlightType.ERROR, textRange);
            builder.create();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GrRangeExpression.BoundaryType.values().length];
            try {
                nArray[GrRangeExpression.BoundaryType.LEFT_OPEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GrRangeExpression.BoundaryType.BOTH_OPEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

