/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyNonShortCircuitBooleanInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.non.short.circuit.boolean.expression", new Object[0]);
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyNonShortCircuitBooleanInspection.$$$reportNull$$$0(0);
        }
        return new NonShortCircuitBooleanFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection", "buildFix"));
    }

    private static class NonShortCircuitBooleanFix
    extends GroovyFix {
        private NonShortCircuitBooleanFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.replace.with.short.circuit.expression", new Object[0]);
            if (string == null) {
                NonShortCircuitBooleanFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                NonShortCircuitBooleanFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                NonShortCircuitBooleanFix.$$$reportNull$$$0(2);
            }
            GrBinaryExpression expression = (GrBinaryExpression)descriptor2.getPsiElement();
            GrExpression lhs = expression.getLeftOperand();
            GrExpression rhs = expression.getRightOperand();
            IElementType operationSign = expression.getOperationTokenType();
            assert (rhs != null);
            String newExpression = lhs.getText() + NonShortCircuitBooleanFix.getShortCircuitOperand(operationSign) + rhs.getText();
            NonShortCircuitBooleanFix.replaceExpression(expression, newExpression);
        }

        private static String getShortCircuitOperand(IElementType tokenType) {
            if (tokenType.equals(GroovyTokenTypes.mBAND)) {
                return "&&";
            }
            return "||";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection$NonShortCircuitBooleanFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection$NonShortCircuitBooleanFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            IElementType sign = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mBAND.equals(sign) && !GroovyTokenTypes.mBOR.equals(sign)) {
                return;
            }
            if (!PsiTypes.booleanType().equals((Object)rhs.getType())) {
                return;
            }
            this.registerError(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection$Visitor", "visitBinaryExpression"));
        }
    }
}

