/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.HashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class ClashingGettersInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("getter.0.clashes.with.getter.1", args);
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                if (typeDefinition == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitTypeDefinition(typeDefinition);
                HashMap<String, PsiMethod> getters = new HashMap<String, PsiMethod>();
                for (PsiMethod method : typeDefinition.getMethods()) {
                    String methodName = method.getName();
                    if (!GroovyPropertyUtils.isSimplePropertyGetter(method)) continue;
                    String propertyName = GroovyPropertyUtils.getPropertyNameByGetterName(methodName, true);
                    PsiMethod otherGetter = (PsiMethod)getters.get(propertyName);
                    if (otherGetter != null && !methodName.equals(otherGetter.getName())) {
                        Pair<PsiElement, String> description = ClashingGettersInspection.getGetterDescription(method);
                        Pair<PsiElement, String> otherDescription = ClashingGettersInspection.getGetterDescription(otherGetter);
                        if (description.first != null) {
                            this.registerError((PsiElement)description.first, description.second, otherDescription.second);
                        }
                        if (otherDescription.first == null) continue;
                        this.registerError((PsiElement)otherDescription.first, otherDescription.second, description.second);
                        continue;
                    }
                    getters.put(propertyName, method);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingGettersInspection$1", "visitTypeDefinition"));
            }
        };
    }

    private static Pair<PsiElement, @Nls String> getGetterDescription(PsiMethod getter) {
        String name = getter.getName();
        if (getter instanceof GrGdkMethod) {
            return new Pair(null, (Object)GroovyBundle.message("getter.kind.gdk.method.0", name));
        }
        if (getter instanceof GrReflectedMethod) {
            getter = ((GrReflectedMethod)getter).getBaseMethod();
            String info = PsiFormatUtil.formatMethod((PsiMethod)getter, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)3);
            return Pair.create((Object)((GrMethod)getter).getNameIdentifierGroovy(), (Object)GroovyBundle.message("getter.kind.method.0", info));
        }
        if (getter instanceof GrMethod) {
            return Pair.create((Object)((GrMethod)getter).getNameIdentifierGroovy(), (Object)GroovyBundle.message("getter.kind.getter.0", name));
        }
        String info = PsiFormatUtil.formatMethod((PsiMethod)getter, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)3);
        return new Pair(null, (Object)GroovyBundle.message("getter.kind.method.0", info));
    }
}

