/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.dsl.DslActivationStatus;
import org.jetbrains.plugins.groovy.dsl.GdslUtil;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class GroovyDslAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        String error;
        if (psiElement == null) {
            GroovyDslAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            GroovyDslAnnotator.$$$reportNull$$$0(1);
        }
        if (!(psiElement instanceof GroovyFile)) {
            return;
        }
        GroovyFile groovyFile = (GroovyFile)psiElement;
        if (!GrFileIndexUtil.isGroovySourceFile(groovyFile)) {
            return;
        }
        VirtualFile vfile = groovyFile.getVirtualFile();
        if (!GdslUtil.GDSL_FILTER.value((Object)vfile)) {
            return;
        }
        DslActivationStatus.Status status = GroovyDslFileIndex.getStatus(vfile);
        if (status == DslActivationStatus.Status.ACTIVE) {
            return;
        }
        String message = status == DslActivationStatus.Status.MODIFIED ? GroovyBundle.message("inspection.message.dsl.descriptor.file.has.been.changed.and.isnt.currently.executed", new Object[0]) : GroovyBundle.message("inspection.message.dsl.descriptor.file.has.been.disabled.due.to.processing.error", new Object[0]);
        AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.WARNING, message).fileLevel().withFix((IntentionAction)new ActivateFix(vfile));
        if (status == DslActivationStatus.Status.ERROR && (error = GroovyDslFileIndex.getError(vfile)) != null) {
            builder = builder.withFix(GroovyQuickFixFactory.getInstance().createInvestigateFix(error));
        }
        builder.create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ActivateFix
    implements IntentionAction {
        private final VirtualFile myVfile;

        ActivateFix(VirtualFile vfile) {
            this.myVfile = vfile;
        }

        @NotNull
        public String getText() {
            String string = GroovyBundle.message("intention.name.activate.back", new Object[0]);
            if (string == null) {
                ActivateFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.activate.dsl.descriptor", new Object[0]);
            if (string == null) {
                ActivateFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                ActivateFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                ActivateFix.$$$reportNull$$$0(3);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            GroovyDslFileIndex.activate(this.myVfile);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$ActivateFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$ActivateFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

