/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.MutablyNamedIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ComparisonPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;

public class NegateComparisonIntention
extends MutablyNamedIntention {
    @Override
    @IntentionName
    @NotNull
    protected String getTextForElement(@NotNull PsiElement element) {
        if (element == null) {
            NegateComparisonIntention.$$$reportNull$$$0(0);
        }
        GrBinaryExpression binaryExpression = (GrBinaryExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        String comparison = ComparisonUtils.getStringForComparison(tokenType);
        String negatedComparison = ComparisonUtils.getNegatedComparison(tokenType);
        String string = GroovyIntentionsBundle.message("negate.comparison.intention.name", comparison, negatedComparison);
        if (string == null) {
            NegateComparisonIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ComparisonPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            NegateComparisonIntention.$$$reportNull$$$0(2);
        }
        if (project == null) {
            NegateComparisonIntention.$$$reportNull$$$0(3);
        }
        GrBinaryExpression exp = (GrBinaryExpression)element;
        IElementType tokenType = exp.getOperationTokenType();
        GrExpression lhs = exp.getLeftOperand();
        String lhsText = lhs.getText();
        GrExpression rhs = exp.getRightOperand();
        String rhsText = rhs.getText();
        String negatedComparison = ComparisonUtils.getNegatedComparison(tokenType);
        String newExpression = lhsText + negatedComparison + rhsText;
        NegateComparisonIntention.replaceExpressionWithNegatedExpressionString(newExpression, exp);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/NegateComparisonIntention";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/NegateComparisonIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTextForElement";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

