/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrVariableStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.typing.TuplesKt;

public class GrVariableImpl
extends GrVariableBaseImpl<GrVariableStub>
implements GrVariable {
    public GrVariableImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrVariableImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrVariableImpl(@NotNull GrVariableStub stub) {
        if (stub == null) {
            GrVariableImpl.$$$reportNull$$$0(1);
        }
        super(stub, GroovyStubElementTypes.VARIABLE);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrVariableImpl.$$$reportNull$$$0(2);
        }
        visitor2.visitVariable(this);
    }

    public String toString() {
        return "Variable";
    }

    public PsiElement getContext() {
        return ResolveUtil.isScriptField(this) ? this.getContainingFile() : super.getContext();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GrScriptField field = ResolveUtil.findScriptField(this);
        SearchScope searchScope = field != null ? field.getUseScope() : super.getUseScope();
        if (searchScope == null) {
            GrVariableImpl.$$$reportNull$$$0(3);
        }
        return searchScope;
    }

    @Nullable
    protected Icon getElementIcon(int flags) {
        return JetgroovyIcons.Groovy.Variable;
    }

    @Override
    @Nullable
    public GrExpression getInitializerGroovy() {
        GrVariableDeclaration declaration;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrVariableDeclaration && (declaration = (GrVariableDeclaration)parent2).isTuple()) {
            GrExpression rValue = declaration.getTupleInitializer();
            if (!(rValue instanceof GrListOrMap)) {
                return null;
            }
            int position = ArrayUtil.indexOf((Object[])declaration.getVariables(), (Object)this);
            if (position < 0) {
                return null;
            }
            GrExpression[] initializers = ((GrListOrMap)rValue).getInitializers();
            if (position < initializers.length) {
                return initializers[position];
            }
            return null;
        }
        return super.getInitializerGroovy();
    }

    @Override
    @Nullable
    public PsiType getInitializerType() {
        GrVariableDeclaration declaration;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrVariableDeclaration && (declaration = (GrVariableDeclaration)parent2).isTuple()) {
            GrExpression rValue = declaration.getTupleInitializer();
            if (rValue == null) {
                return null;
            }
            int position = ArrayUtil.indexOf((Object[])declaration.getVariables(), (Object)this);
            if (position < 0) {
                return null;
            }
            return TuplesKt.getMultiAssignmentType(rValue, position);
        }
        return super.getInitializerType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

