/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public interface TypeConstants {
    public static final int BYTE_RANK = 1;
    public static final int CHARACTER_RANK = 2;
    public static final int SHORT_RANK = 3;
    public static final int INTEGER_RANK = 4;
    public static final int LONG_RANK = 5;
    public static final int BIG_INTEGER_RANK = 6;
    public static final int BIG_DECIMAL_RANK = 7;
    public static final int FLOAT_RANK = 8;
    public static final int DOUBLE_RANK = 9;

    public static int getTypeRank(@Nullable PsiType type2) {
        if (type2 instanceof PsiClassType) {
            return TypesUtil.TYPE_TO_RANK.getInt((Object)TypesUtil.getQualifiedName(type2));
        }
        if (type2 instanceof PsiPrimitiveType) {
            return TypesUtil.TYPE_TO_RANK.getInt((Object)((PsiPrimitiveType)type2).getBoxedTypeName());
        }
        return 0;
    }

    @Nullable
    public static String getTypeFqn(int rank) {
        return (String)TypesUtil.RANK_TO_TYPE.get(rank);
    }
}

