/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorProcessor;

public final class GroovyPropertyUtils {
    private static final Logger LOG = Logger.getInstance(GroovyPropertyUtils.class);
    public static final String IS_PREFIX = "is";
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";

    private GroovyPropertyUtils() {
    }

    public static PsiMethod[] getAllSettersByField(PsiField field) {
        return GroovyPropertyUtils.getAllSetters(field.getContainingClass(), field.getName(), field.hasModifierProperty("static"), false);
    }

    public static PsiMethod @NotNull [] getAllGettersByField(PsiField field) {
        return GroovyPropertyUtils.getAllGetters(field.getContainingClass(), field.getName(), field.hasModifierProperty("static"), false);
    }

    @Nullable
    public static PsiMethod findSetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        return GroovyPropertyUtils.findPropertySetter(containingClass, propertyName, isStatic, true);
    }

    @Nullable
    public static PsiMethod findGetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        return GroovyPropertyUtils.findPropertyGetter(containingClass, propertyName, isStatic, true);
    }

    @Nullable
    public static PsiMethod findPropertySetter(@Nullable PsiType type2, String propertyName, @NotNull GroovyPsiElement context) {
        if (context == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(0);
        }
        String setterName = GroovyPropertyUtils.getSetterName(propertyName);
        if (type2 == null) {
            GrExpression fromText = GroovyPsiElementFactory.getInstance(context.getProject()).createExpressionFromText("this", context);
            return GroovyPropertyUtils.findPropertySetter(fromText.getType(), propertyName, context);
        }
        AccessorProcessor processor = new AccessorProcessor(propertyName, PropertyKind.SETTER, null, context);
        ResolveUtil.processAllDeclarations(type2, (PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)context);
        return PsiImplUtil.extractUniqueElement(processor.getResults().toArray(GroovyResolveResult.EMPTY_ARRAY));
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !GroovyPropertyUtils.isSimplePropertySetter(method) || !propertyName.equals(GroovyPropertyUtils.getPropertyNameBySetter(method))) continue;
            return method;
        }
        return null;
    }

    public static PsiMethod @NotNull [] getAllGetters(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (propertyName == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(1);
        }
        if (aClass == null) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                GroovyPropertyUtils.$$$reportNull$$$0(2);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !GroovyPropertyUtils.isSimplePropertyGetter(method) || !propertyName.equals(GroovyPropertyUtils.getPropertyNameByGetter(method))) continue;
            result2.add(method);
        }
        PsiMethod[] psiMethodArray = result2.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    public static PsiMethod @NotNull [] getAllSetters(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (propertyName == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(4);
        }
        if (aClass == null) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                GroovyPropertyUtils.$$$reportNull$$$0(5);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !GroovyPropertyUtils.isSimplePropertySetter(method) || !propertyName.equals(GroovyPropertyUtils.getPropertyNameBySetter(method))) continue;
            result2.add(method);
        }
        PsiMethod[] psiMethodArray = result2.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(6);
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiMethod findPropertyGetter(@Nullable PsiClass aClass, String propertyName, @Nullable Boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (isStatic != null && method.hasModifierProperty("static") != isStatic.booleanValue() || !GroovyPropertyUtils.isSimplePropertyGetter(method) || !propertyName.equals(GroovyPropertyUtils.getPropertyNameByGetter(method))) continue;
            return method;
        }
        return null;
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return GroovyPropertyUtils.isSimplePropertyGetter(method) || GroovyPropertyUtils.isSimplePropertySetter(method);
    }

    public static boolean isSimplePropertyGetter(PsiMethod method) {
        return GroovyPropertyUtils.isSimplePropertyGetter(method, null);
    }

    public static boolean isSimplePropertyGetter(PsiMethod method, @Nullable String propertyName) {
        if (method == null || method.isConstructor()) {
            return false;
        }
        if (!method.getParameterList().isEmpty()) {
            return false;
        }
        if (!GroovyPropertyUtils.isGetterName(method.getName())) {
            return false;
        }
        boolean booleanReturnType = GroovyPropertyUtils.isBooleanOrBoxed(method.getReturnType());
        if (method.getName().startsWith(IS_PREFIX) && !booleanReturnType) {
            return false;
        }
        if (PsiTypes.voidType().equals((Object)method.getReturnType())) {
            return false;
        }
        if (propertyName == null) {
            return true;
        }
        String byGetter = GroovyPropertyUtils.getPropertyNameByGetter(method);
        return propertyName.equals(byGetter) || !GroovyPropertyUtils.isPropertyName(byGetter) && propertyName.equals(GroovyPropertyUtils.getPropertyNameByGetterName(method.getName(), booleanReturnType));
    }

    public static boolean isSimplePropertySetter(PsiMethod method) {
        return GroovyPropertyUtils.isSimplePropertySetter(method, null);
    }

    public static boolean isSimplePropertySetter(PsiMethod method, @Nullable String propertyName) {
        if (method == null || method.isConstructor()) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        if (!GroovyPropertyUtils.isSetterName(method.getName())) {
            return false;
        }
        if (propertyName == null) {
            return true;
        }
        String bySetter = GroovyPropertyUtils.getPropertyNameBySetter(method);
        return propertyName.equals(bySetter) || !GroovyPropertyUtils.isPropertyName(bySetter) && propertyName.equals(GroovyPropertyUtils.getPropertyNameBySetterName(method.getName()));
    }

    public static boolean isSetterLike(@NotNull PsiMethod method, @NotNull String prefix) {
        if (method == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(8);
        }
        if (method.isConstructor()) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        return GroovyPropertyUtils.isPropertyName(method.getName(), prefix);
    }

    @Nullable
    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        if (getterMethod instanceof GrAccessorMethod) {
            return ((GrAccessorMethod)getterMethod).getProperty().getName();
        }
        @NonNls String methodName = getterMethod.getName();
        boolean isPropertyBoolean = GroovyPropertyUtils.isBooleanOrBoxed(getterMethod.getReturnType());
        return GroovyPropertyUtils.getPropertyNameByGetterName(methodName, isPropertyBoolean);
    }

    @Nullable
    public static String getPropertyNameByGetterName(@NotNull String methodName, boolean canBeBoolean) {
        if (methodName == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(9);
        }
        if (methodName.startsWith(GET_PREFIX) && methodName.length() > 3) {
            return GroovyPropertyUtils.decapitalize(methodName.substring(3));
        }
        if (canBeBoolean && methodName.startsWith(IS_PREFIX) && methodName.length() > 2) {
            return GroovyPropertyUtils.decapitalize(methodName.substring(2));
        }
        return null;
    }

    @Nullable
    public static String getPropertyNameBySetter(PsiMethod setterMethod) {
        if (setterMethod instanceof GrAccessorMethod) {
            return ((GrAccessorMethod)setterMethod).getProperty().getName();
        }
        @NonNls String methodName = setterMethod.getName();
        return GroovyPropertyUtils.getPropertyNameBySetterName(methodName);
    }

    @Nullable
    public static String getPropertyNameBySetterName(@NotNull String methodName) {
        if (methodName == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(10);
        }
        if (methodName.startsWith(SET_PREFIX) && methodName.length() > 3) {
            return StringUtil.decapitalize((String)methodName.substring(3));
        }
        return null;
    }

    @Nullable
    public static String getPropertyNameByAccessorName(String accessorName) {
        if (GroovyPropertyUtils.isGetterName(accessorName)) {
            return GroovyPropertyUtils.getPropertyNameByGetterName(accessorName, true);
        }
        if (GroovyPropertyUtils.isSetterName(accessorName)) {
            return GroovyPropertyUtils.getPropertyNameBySetterName(accessorName);
        }
        return null;
    }

    @Nullable
    public static String getPropertyName(PsiMethod accessor) {
        if (GroovyPropertyUtils.isSimplePropertyGetter(accessor)) {
            return GroovyPropertyUtils.getPropertyNameByGetter(accessor);
        }
        if (GroovyPropertyUtils.isSimplePropertySetter(accessor)) {
            return GroovyPropertyUtils.getPropertyNameBySetter(accessor);
        }
        return null;
    }

    public static boolean isGetterName(@NotNull String name) {
        int prefixLength;
        if (name == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(11);
        }
        if (name.startsWith(GET_PREFIX)) {
            prefixLength = 3;
        } else if (name.startsWith(IS_PREFIX)) {
            prefixLength = 2;
        } else {
            return false;
        }
        if (name.length() == prefixLength) {
            return false;
        }
        if (GroovyPropertyUtils.isUpperCase(name.charAt(prefixLength))) {
            return true;
        }
        return name.length() > prefixLength + 1 && GroovyPropertyUtils.isUpperCase(name.charAt(prefixLength + 1));
    }

    public static String getGetterNameNonBoolean(@NotNull String name) {
        if (name == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(12);
        }
        return GroovyPropertyUtils.getAccessorName(GET_PREFIX, name);
    }

    public static String getGetterNameForRecordField(@NotNull String name) {
        if (name == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(13);
        }
        return name;
    }

    public static String getGetterNameBoolean(@NotNull String name) {
        if (name == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(14);
        }
        return GroovyPropertyUtils.getAccessorName(IS_PREFIX, name);
    }

    public static String getSetterName(@NotNull String name) {
        if (name == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(15);
        }
        return GroovyPropertyUtils.getAccessorName(SET_PREFIX, name);
    }

    public static String getAccessorName(String prefix, String name) {
        if (name.isEmpty()) {
            return prefix;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            sb.append(name);
        } else {
            sb.append(Character.toUpperCase(name.charAt(0)));
            sb.append(name, 1, name.length());
        }
        return sb.toString();
    }

    public static String[] suggestGettersName(@NotNull String name) {
        if (name == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(16);
        }
        return new String[]{GroovyPropertyUtils.getGetterNameBoolean(name), GroovyPropertyUtils.getGetterNameNonBoolean(name)};
    }

    public static boolean isPropertyName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return !Character.isUpperCase(name.charAt(0)) || name.length() != 1 && Character.isUpperCase(name.charAt(1));
    }

    public static String[] suggestSettersName(@NotNull String name) {
        if (name == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(17);
        }
        return new String[]{GroovyPropertyUtils.getSetterName(name)};
    }

    @Contract(value="null -> false")
    public static boolean isSetterName(@Nullable String name) {
        return GroovyPropertyUtils.isPropertyName(name, SET_PREFIX);
    }

    @Contract(value="null, _ -> false")
    public static boolean isPropertyName(@Nullable String name, @NotNull String prefix) {
        if (prefix == null) {
            GroovyPropertyUtils.$$$reportNull$$$0(18);
        }
        return name != null && name.startsWith(prefix) && name.length() > prefix.length() && GroovyPropertyUtils.isUpperCase(name.charAt(prefix.length()));
    }

    public static boolean isProperty(@Nullable PsiClass aClass, @Nullable String propertyName, boolean isStatic) {
        if (aClass == null || propertyName == null) {
            return false;
        }
        PsiField field = aClass.findFieldByName(propertyName, true);
        if (field instanceof GrField && ((GrField)field).isProperty() && field.hasModifierProperty("static") == isStatic) {
            return true;
        }
        PsiMethod getter = GroovyPropertyUtils.findPropertyGetter(aClass, propertyName, isStatic, true);
        if (getter != null && getter.hasModifierProperty("public")) {
            return true;
        }
        PsiMethod setter = GroovyPropertyUtils.findPropertySetter(aClass, propertyName, isStatic, true);
        return setter != null && setter.hasModifierProperty("public");
    }

    public static boolean isProperty(GrField field) {
        PsiClass clazz = field.getContainingClass();
        return GroovyPropertyUtils.isProperty(clazz, field.getName(), field.hasModifierProperty("static"));
    }

    private static boolean isUpperCase(char c) {
        return Character.toUpperCase(c) == c;
    }

    public static String capitalize(String s) {
        if (s.isEmpty()) {
            return s;
        }
        if (s.length() == 1) {
            return StringUtil.toUpperCase((String)s);
        }
        if (Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        char[] chars2 = s.toCharArray();
        chars2[0] = Character.toUpperCase(chars2[0]);
        return new String(chars2);
    }

    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    @Nullable
    public static PsiField findFieldForAccessor(PsiMethod accessor, boolean checkSuperClasses) {
        PsiClass psiClass = accessor.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        PsiField field = null;
        if (!checkSuperClasses) {
            field = psiClass.findFieldByName(GroovyPropertyUtils.getPropertyNameByAccessorName(accessor.getName()), true);
        } else {
            PsiField[] allFields;
            String name = GroovyPropertyUtils.getPropertyNameByAccessorName(accessor.getName());
            assert (name != null);
            for (PsiField psiField : allFields = psiClass.getAllFields()) {
                if (!name.equals(psiField.getName())) continue;
                field = psiField;
                break;
            }
        }
        if (field == null) {
            return null;
        }
        if (field.hasModifierProperty("static") == accessor.hasModifierProperty("static")) {
            return field;
        }
        return null;
    }

    @Nullable
    public static String getGetterPrefix(PsiMethod getter) {
        String name = getter.getName();
        if (name.startsWith(GET_PREFIX)) {
            return GET_PREFIX;
        }
        if (name.startsWith(IS_PREFIX)) {
            return IS_PREFIX;
        }
        return null;
    }

    @Nullable
    public static String getSetterPrefix(PsiMethod setter) {
        if (setter.getName().startsWith(SET_PREFIX)) {
            return SET_PREFIX;
        }
        return null;
    }

    @Nullable
    public static String getAccessorPrefix(PsiMethod method) {
        String prefix = GroovyPropertyUtils.getGetterPrefix(method);
        if (prefix != null) {
            return prefix;
        }
        return GroovyPropertyUtils.getSetterPrefix(method);
    }

    public static boolean isAccessorFor(PsiMethod accessor, PsiField field) {
        String fieldName;
        String accessorName = accessor.getName();
        if (!ArrayUtil.contains((String)accessorName, (String[])GroovyPropertyUtils.suggestGettersName(fieldName = field.getName())) && !ArrayUtil.contains((String)accessorName, (String[])GroovyPropertyUtils.suggestSettersName(fieldName))) {
            return false;
        }
        PsiClass accessorClass = accessor.getContainingClass();
        PsiClass fieldClass = field.getContainingClass();
        if (!field.getManager().areElementsEquivalent((PsiElement)accessorClass, (PsiElement)fieldClass)) {
            return false;
        }
        return accessor.hasModifierProperty("static") == field.hasModifierProperty("static");
    }

    public static List<GrAccessorMethod> getFieldAccessors(GrField field) {
        ArrayList<GrAccessorMethod> accessors = new ArrayList<GrAccessorMethod>();
        GrAccessorMethod[] getters = field.getGetters();
        Collections.addAll(accessors, getters);
        GrAccessorMethod setter = field.getSetter();
        if (setter != null) {
            accessors.add(setter);
        }
        return accessors;
    }

    public static GrMethod generateGetterPrototype(PsiField field) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(field.getProject());
        String name = field.getName();
        String getName = GroovyPropertyUtils.getGetterNameNonBoolean(field.getName());
        try {
            PsiType type2 = field instanceof GrField ? ((GrField)field).getDeclaredType() : field.getType();
            GrMethod getter = factory.createMethod(getName, type2);
            if (field.hasModifierProperty("static")) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)getter, (String)"static", (boolean)true);
            }
            GroovyPropertyUtils.annotateWithNullableStuff((PsiModifierListOwner)field, getter);
            GrCodeBlock body = factory.createMethodBodyFromText("\nreturn " + name + "\n");
            getter.getBlock().replace(body);
            return getter;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static GrMethod generateSetterPrototype(PsiField field) {
        Project project = field.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        String name = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        VariableKind kind = codeStyleManager.getVariableKind((PsiVariable)field);
        String propertyName = codeStyleManager.variableNameToPropertyName(name, kind);
        String setName = GroovyPropertyUtils.getSetterName(field.getName());
        PsiClass containingClass = field.getContainingClass();
        try {
            GrMethod setMethod = factory.createMethod(setName, (PsiType)PsiTypes.voidType());
            String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            PsiType type2 = field instanceof GrField ? ((GrField)field).getDeclaredType() : field.getType();
            GrParameter param = factory.createParameter(parameterName, type2);
            GroovyPropertyUtils.annotateWithNullableStuff((PsiModifierListOwner)field, (PsiModifierListOwner)param);
            setMethod.getParameterList().add(param);
            PsiUtil.setModifierProperty((PsiModifierListOwner)setMethod, (String)"static", (boolean)isStatic);
            @NonNls StringBuilder builder = new StringBuilder();
            if (name.equals(parameterName)) {
                if (!isStatic) {
                    builder.append("this.");
                } else {
                    String className = containingClass.getName();
                    if (className != null) {
                        builder.append(className);
                        builder.append(".");
                    }
                }
            }
            builder.append(name);
            builder.append("=");
            builder.append(parameterName);
            builder.append("\n");
            GrCodeBlock body = factory.createMethodBodyFromText(builder.toString());
            setMethod.getBlock().replace(body);
            return setMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static void annotateWithNullableStuff(PsiModifierListOwner original, PsiModifierListOwner generated) throws IncorrectOperationException {
        NullableNotNullManager.getInstance((Project)original.getProject()).copyNullableOrNotNullAnnotation(original, generated);
        PsiModifierList modifierList = generated.getModifierList();
        if (modifierList != null && modifierList.hasExplicitModifier("def")) {
            LOG.assertTrue(modifierList instanceof GrModifierList);
            if (modifierList.getAnnotations().length > 0 || ((GrModifierList)modifierList).getModifiers().length > 1) {
                modifierList.setModifierProperty("def", false);
            }
        }
    }

    private static boolean isBooleanOrBoxed(PsiType type2) {
        return PsiTypes.booleanType().equals((Object)type2) || PsiTypes.booleanType().equals((Object)PsiPrimitiveType.getUnboxedType((PsiType)type2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/util/GroovyPropertyUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/util/GroovyPropertyUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGetters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSetters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySetter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllGetters";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllSetters";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSetterLike";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameByGetterName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameBySetterName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGetterName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getGetterNameNonBoolean";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGetterNameForRecordField";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getGetterNameBoolean";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSetterName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "suggestGettersName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "suggestSettersName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

