/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.ConvertToStatic;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.TypeChecker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/Intention;", "()V", "checkUnresolvedReferences", "", "element", "Lcom/intellij/psi/PsiElement;", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "getFamilyName", "", "getText", "isCSAnnotated", "processIntention", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.groovy"})
public final class ConvertToStaticIntention
extends Intention {
    @Override
    @NotNull
    public String getText() {
        String string = GroovyRefactoringBundle.message("intention.converting.to.static", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"intention.converting.to.static\")");
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyRefactoringBundle.message("intention.converting.to.static.family", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"intention.converting.to.static.family\")");
        return string;
    }

    private final boolean isCSAnnotated(PsiElement element) {
        if (!(element instanceof GrMember)) {
            return false;
        }
        PsiAnnotation psiAnnotation = CompileStaticUtil.getCompileStaticAnnotation((PsiMember)element);
        if (psiAnnotation == null) {
            return false;
        }
        PsiAnnotation annotation = psiAnnotation;
        return CompileStaticUtil.checkForPass(annotation);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement psiElement = PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, arg_0 -> ConvertToStaticIntention.processIntention$lambda$0((Function1)new Function1<PsiElement, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull PsiElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ConvertToStaticIntention.access$isCSAnnotated((ConvertToStaticIntention)this.receiver, p0);
            }
        }, arg_0));
        GrMember grMember = psiElement instanceof GrMember ? (GrMember)psiElement : null;
        if (grMember == null) {
            return;
        }
        GrMember containingMember2 = grMember;
        ConvertToStatic.applyDeclarationFixes(containingMember2);
        ConvertToStatic.applyErrorFixes(containingMember2);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return arg_0 -> ConvertToStaticIntention.getElementPredicate$lambda$1(this, arg_0);
    }

    private final boolean checkUnresolvedReferences(PsiElement element) {
        GrReferenceExpression grReferenceExpression = element instanceof GrReferenceExpression ? (GrReferenceExpression)element : null;
        if (grReferenceExpression == null) {
            return false;
        }
        GrReferenceExpression expression = grReferenceExpression;
        if (expression.advancedResolve().isValidResult()) {
            return false;
        }
        GrExpression grExpression = expression.getQualifierExpression();
        if (grExpression == null) {
            return false;
        }
        GrExpression qualifier = grExpression;
        return !((Collection)ConvertToStatic.collectReferencedEmptyDeclarations(qualifier, false)).isEmpty();
    }

    private static final boolean processIntention$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getElementPredicate$lambda$1(ConvertToStaticIntention this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!CompileStaticUtil.isCompileStatic(it)) {
            return false;
        }
        TypeChecker checker = new TypeChecker();
        it.accept((PsiElementVisitor)new GroovyPsiElementVisitor(checker));
        List<TypeChecker.ProblemFix> list = checker.getFixes();
        Intrinsics.checkNotNullExpressionValue(list, (String)"checker.fixes");
        if (!((Collection)list).isEmpty()) {
            return true;
        }
        return this$0.checkUnresolvedReferences(it);
    }

    public static final /* synthetic */ boolean access$isCSAnnotated(ConvertToStaticIntention $this, PsiElement element) {
        return $this.isCSAnnotated(element);
    }
}

