/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

class TasksFromProjectDependencies
implements TaskDependencyContainerInternal {
    private final String taskName;
    private final TaskDependencyContainerInternal taskDependencyDelegate;

    public TasksFromProjectDependencies(String taskName, Supplier<DependencySet> dependencies, TaskDependencyFactory taskDependencyFactory) {
        this.taskName = taskName;
        this.taskDependencyDelegate = taskDependencyFactory.visitingDependencies(context -> this.resolveProjectDependencies((TaskDependencyResolveContext)context, (Set<ProjectDependency>)((Object)((DependencySet)dependencies.get()).withType(ProjectDependency.class))));
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.taskDependencyDelegate.visitDependencies(context);
    }

    void resolveProjectDependencies(TaskDependencyResolveContext context, Set<ProjectDependency> projectDependencies) {
        for (ProjectDependency projectDependency : projectDependencies) {
            ProjectInternal dependencyProject = (ProjectInternal)projectDependency.getDependencyProject();
            dependencyProject.getOwner().ensureTasksDiscovered();
            Task nextTask = (Task)projectDependency.getDependencyProject().getTasks().findByName(this.taskName);
            if (nextTask == null || context.getTask() == nextTask) continue;
            context.add(nextTask);
        }
    }

    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public Set<? extends Task> getDependencies(@Nullable Task task) {
        return this.taskDependencyDelegate.getDependencies(task);
    }

    @Override
    public Set<? extends Task> getDependenciesForInternalUse(@Nullable Task task) {
        return this.taskDependencyDelegate.getDependenciesForInternalUse(task);
    }
}

