/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.VersionConstraintInternal;
import org.gradle.api.internal.artifacts.dependencies.AbstractVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DefaultMutableVersionConstraint
extends AbstractVersionConstraint
implements VersionConstraintInternal {
    private String requiredVersion;
    private String preferredVersion;
    private String strictVersion;
    private String branch;
    private final List<String> rejectedVersions = Lists.newArrayListWithExpectedSize((int)1);

    public DefaultMutableVersionConstraint(VersionConstraint versionConstraint) {
        this(versionConstraint.getPreferredVersion(), versionConstraint.getRequiredVersion(), versionConstraint.getStrictVersion(), versionConstraint.getRejectedVersions(), versionConstraint.getBranch());
    }

    public DefaultMutableVersionConstraint(String version) {
        this(null, version, null);
    }

    private DefaultMutableVersionConstraint(@Nullable String preferredVersion, String requiredVersion, @Nullable String strictVersion) {
        this(preferredVersion, requiredVersion, strictVersion, Collections.emptyList(), null);
    }

    private DefaultMutableVersionConstraint(@Nullable String preferredVersion, String requiredVersion, @Nullable String strictVersion, List<String> rejects, @Nullable String branch) {
        this.updateVersions(preferredVersion, requiredVersion, strictVersion);
        for (String reject : rejects) {
            this.rejectedVersions.add(Strings.nullToEmpty((String)reject));
        }
        this.branch = branch;
    }

    private void updateVersions(@Nullable String preferredVersion, @Nullable String requiredVersion, @Nullable String strictVersion) {
        this.preferredVersion = Strings.nullToEmpty((String)preferredVersion);
        this.requiredVersion = Strings.nullToEmpty((String)requiredVersion);
        this.strictVersion = Strings.nullToEmpty((String)strictVersion);
        this.rejectedVersions.clear();
    }

    public static DefaultMutableVersionConstraint withVersion(String version) {
        return new DefaultMutableVersionConstraint(version);
    }

    public static DefaultMutableVersionConstraint withStrictVersion(String version) {
        return new DefaultMutableVersionConstraint(null, version, version);
    }

    @Override
    public ImmutableVersionConstraint asImmutable() {
        return new DefaultImmutableVersionConstraint(this.preferredVersion, this.requiredVersion, this.strictVersion, this.rejectedVersions, this.branch);
    }

    @Override
    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(@Nullable String branch) {
        this.branch = branch;
    }

    @Override
    public String getRequiredVersion() {
        return this.requiredVersion;
    }

    @Override
    public void require(String version) {
        this.updateVersions(this.preferredVersion, version, null);
    }

    @Override
    public String getPreferredVersion() {
        return this.preferredVersion;
    }

    @Override
    public void prefer(String version) {
        this.updateVersions(version, this.requiredVersion, this.strictVersion);
    }

    @Override
    public String getStrictVersion() {
        return this.strictVersion;
    }

    @Override
    public void strictly(String version) {
        this.updateVersions(this.preferredVersion, version, version);
    }

    @Override
    public void reject(String ... versions) {
        this.rejectedVersions.clear();
        Collections.addAll(this.rejectedVersions, versions);
    }

    @Override
    public void rejectAll() {
        this.updateVersions(null, null, null);
        this.rejectedVersions.add("+");
    }

    @Override
    public List<String> getRejectedVersions() {
        return this.rejectedVersions;
    }

    public String getVersion() {
        return this.requiredVersion.isEmpty() ? this.preferredVersion : this.requiredVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultMutableVersionConstraint that = (DefaultMutableVersionConstraint)o;
        if (this.requiredVersion != null ? !this.requiredVersion.equals(that.requiredVersion) : that.requiredVersion != null) {
            return false;
        }
        if (this.preferredVersion != null ? !this.preferredVersion.equals(that.preferredVersion) : that.preferredVersion != null) {
            return false;
        }
        if (this.strictVersion != null ? !this.strictVersion.equals(that.strictVersion) : that.strictVersion != null) {
            return false;
        }
        if (this.branch != null ? !this.branch.equals(that.branch) : that.branch != null) {
            return false;
        }
        return this.rejectedVersions.equals(that.rejectedVersions);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.requiredVersion != null ? this.requiredVersion.hashCode() : 0);
        result2 = 31 * result2 + (this.preferredVersion != null ? this.preferredVersion.hashCode() : 0);
        result2 = 31 * result2 + (this.strictVersion != null ? this.strictVersion.hashCode() : 0);
        result2 = 31 * result2 + (this.branch != null ? this.branch.hashCode() : 0);
        result2 = 31 * result2 + this.rejectedVersions.hashCode();
        return result2;
    }
}

