/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.CachingDependencyResolveContext;
import org.gradle.api.internal.artifacts.DependencyResolveContext;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.exceptions.ConfigurationNotConsumableException;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.util.internal.GUtil;

public class DefaultProjectDependency
extends AbstractModuleDependency
implements ProjectDependencyInternal {
    private final ProjectInternal dependencyProject;
    private final boolean buildProjectDependencies;
    private final TaskDependencyFactory taskDependencyFactory;

    public DefaultProjectDependency(ProjectInternal dependencyProject, boolean buildProjectDependencies, TaskDependencyFactory taskDependencyFactory) {
        this(dependencyProject, null, buildProjectDependencies, taskDependencyFactory);
    }

    public DefaultProjectDependency(ProjectInternal dependencyProject, boolean buildProjectDependencies) {
        this(dependencyProject, null, buildProjectDependencies, DefaultTaskDependencyFactory.withNoAssociatedProject());
    }

    public DefaultProjectDependency(ProjectInternal dependencyProject, String configuration, boolean buildProjectDependencies, TaskDependencyFactory taskDependencyFactory) {
        super(configuration);
        this.dependencyProject = dependencyProject;
        this.buildProjectDependencies = buildProjectDependencies;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    @Override
    public Project getDependencyProject() {
        return this.dependencyProject;
    }

    @Override
    public String getGroup() {
        return this.dependencyProject.getGroup().toString();
    }

    @Override
    public String getName() {
        return this.dependencyProject.getName();
    }

    @Override
    public String getVersion() {
        return this.dependencyProject.getVersion().toString();
    }

    @Override
    public Configuration findProjectConfiguration() {
        String declaredConfiguration;
        ConfigurationContainer dependencyConfigurations = this.getDependencyProject().getConfigurations();
        Configuration selectedConfiguration = dependencyConfigurations.getByName(GUtil.elvis(declaredConfiguration = this.getTargetConfiguration(), "default"));
        if (!selectedConfiguration.isCanBeConsumed()) {
            throw new ConfigurationNotConsumableException(this.dependencyProject.getDisplayName(), selectedConfiguration.getName());
        }
        ((DeprecatableConfiguration)selectedConfiguration).maybeEmitConsumptionDeprecation();
        return selectedConfiguration;
    }

    @Override
    public ProjectDependency copy() {
        DefaultProjectDependency copiedProjectDependency = new DefaultProjectDependency(this.dependencyProject, this.getTargetConfiguration(), this.buildProjectDependencies, this.taskDependencyFactory);
        this.copyTo(copiedProjectDependency);
        return copiedProjectDependency;
    }

    @Override
    public Set<File> resolve() {
        return this.resolve(true);
    }

    @Override
    public Set<File> resolve(boolean transitive) {
        CachingDependencyResolveContext context = new CachingDependencyResolveContext(this.taskDependencyFactory, transitive, Collections.emptyMap());
        context.add(this);
        return context.resolve().getFiles();
    }

    @Override
    public void resolve(DependencyResolveContext context) {
        boolean transitive;
        boolean bl = transitive = this.isTransitive() && context.isTransitive();
        if (transitive) {
            Configuration projectConfiguration = this.findProjectConfiguration();
            for (Dependency dependency : projectConfiguration.getAllDependencies()) {
                context.add(dependency);
            }
            for (DependencyConstraint dependencyConstraint : projectConfiguration.getAllDependencyConstraints()) {
                context.add(dependencyConstraint);
            }
        }
    }

    @Override
    public TaskDependencyInternal getBuildDependencies() {
        return this.taskDependencyFactory.visitingDependencies(context -> {
            if (!this.buildProjectDependencies) {
                return;
            }
            Configuration configuration = this.findProjectConfiguration();
            context.add(configuration);
            context.add(configuration.getAllArtifacts());
        });
    }

    @Override
    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (dependency == null || this.getClass() != dependency.getClass()) {
            return false;
        }
        ProjectDependency that = (ProjectDependency)dependency;
        if (!this.isCommonContentEquals(that)) {
            return false;
        }
        return this.dependencyProject.equals(that.getDependencyProject());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDependency that = (DefaultProjectDependency)o;
        if (!this.getDependencyProject().equals(that.getDependencyProject())) {
            return false;
        }
        if (this.getTargetConfiguration() != null ? !this.getTargetConfiguration().equals(that.getTargetConfiguration()) : that.getTargetConfiguration() != null) {
            return false;
        }
        if (this.buildProjectDependencies != that.buildProjectDependencies) {
            return false;
        }
        if (!Objects.equal((Object)this.getAttributes(), (Object)that.getAttributes())) {
            return false;
        }
        return Objects.equal(this.getRequestedCapabilities(), that.getRequestedCapabilities());
    }

    public int hashCode() {
        return this.getDependencyProject().hashCode() ^ (this.getTargetConfiguration() != null ? this.getTargetConfiguration().hashCode() : 31) ^ (this.buildProjectDependencies ? 1 : 0);
    }

    public String toString() {
        return "DefaultProjectDependency{dependencyProject='" + this.dependencyProject + '\'' + ", configuration='" + (this.getTargetConfiguration() == null ? "default" : this.getTargetConfiguration()) + '\'' + '}';
    }
}

