/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.repositories.AbstractResolutionAwareArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.AuthenticationSupporter;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.authentication.Authentication;
import org.gradle.internal.Cast;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.internal.CollectionUtils;

public abstract class AbstractAuthenticationSupportedRepository<T extends RepositoryDescriptor>
extends AbstractResolutionAwareArtifactRepository<T>
implements AuthenticationSupportedInternal {
    private final AuthenticationSupporter delegate;
    private final ProviderFactory providerFactory;

    AbstractAuthenticationSupportedRepository(Instantiator instantiator2, AuthenticationContainer authenticationContainer, ObjectFactory objectFactory, ProviderFactory providerFactory, VersionParser versionParser) {
        super(objectFactory, versionParser);
        this.delegate = new AuthenticationSupporter(instantiator2, objectFactory, authenticationContainer, providerFactory);
        this.providerFactory = providerFactory;
    }

    @Override
    public PasswordCredentials getCredentials() {
        this.invalidateDescriptor();
        return this.delegate.getCredentials();
    }

    @Override
    public <T extends Credentials> T getCredentials(Class<T> credentialsType) {
        this.invalidateDescriptor();
        return this.delegate.getCredentials(credentialsType);
    }

    @Override
    public Property<Credentials> getConfiguredCredentials() {
        return this.delegate.getConfiguredCredentials();
    }

    @Override
    public void setConfiguredCredentials(Credentials credentials) {
        this.invalidateDescriptor();
        this.delegate.setConfiguredCredentials(credentials);
    }

    @Override
    public void credentials(Action<? super PasswordCredentials> action) {
        this.invalidateDescriptor();
        this.delegate.credentials(action);
    }

    @Override
    public <T extends Credentials> void credentials(Class<T> credentialsType, Action<? super T> action) throws IllegalStateException {
        this.invalidateDescriptor();
        this.delegate.credentials(credentialsType, action);
    }

    @Override
    public void credentials(Class<? extends Credentials> credentialsType) {
        this.invalidateDescriptor();
        this.delegate.credentials(credentialsType, this.providerFactory.provider(this::getName));
    }

    @Override
    public void authentication(Action<? super AuthenticationContainer> action) {
        this.invalidateDescriptor();
        this.delegate.authentication(action);
    }

    @Override
    public AuthenticationContainer getAuthentication() {
        this.invalidateDescriptor();
        return this.delegate.getAuthentication();
    }

    @Override
    public Collection<Authentication> getConfiguredAuthentication() {
        Collection<Authentication> configuredAuthentication = this.delegate.getConfiguredAuthentication();
        for (Authentication authentication : configuredAuthentication) {
            AuthenticationInternal authenticationInternal = (AuthenticationInternal)authentication;
            for (URI repositoryUrl : this.getRepositoryUrls()) {
                if (!repositoryUrl.getScheme().startsWith("http")) continue;
                authenticationInternal.addHost(repositoryUrl.getHost(), repositoryUrl.getPort());
            }
        }
        return configuredAuthentication;
    }

    protected Collection<URI> getRepositoryUrls() {
        return Collections.emptyList();
    }

    List<String> getAuthenticationSchemes() {
        return CollectionUtils.collect(this.getConfiguredAuthentication(), authentication -> Cast.cast(AuthenticationInternal.class, authentication).getType().getSimpleName());
    }

    boolean usesCredentials() {
        return this.delegate.usesCredentials();
    }
}

