/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ArtifactTransformRegistration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.DefaultVariantDefinition;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.collections.ImmutableFilteredList;
import org.gradle.internal.component.model.AttributeMatcher;

public class ConsumerProvidedVariantFinder {
    private final VariantTransformRegistry variantTransforms;
    private final ImmutableAttributesFactory attributesFactory;
    private final CachingAttributeMatcher matcher;
    private final TransformationCache transformationCache;

    public ConsumerProvidedVariantFinder(VariantTransformRegistry variantTransforms, AttributesSchemaInternal schema, ImmutableAttributesFactory attributesFactory) {
        this.variantTransforms = variantTransforms;
        this.attributesFactory = attributesFactory;
        this.matcher = new CachingAttributeMatcher(schema.matcher());
        this.transformationCache = new TransformationCache(this::doFindTransformedVariants);
    }

    public List<TransformedVariant> findTransformedVariants(List<ResolvedVariant> sources, ImmutableAttributes requested) {
        return this.transformationCache.query(sources, requested);
    }

    private List<CachedVariant> doFindTransformedVariants(List<ImmutableAttributes> sources, ImmutableAttributes requested) {
        ArrayList<ChainState> toProcess = new ArrayList<ChainState>();
        ArrayList<ChainState> nextDepth = new ArrayList<ChainState>();
        toProcess.add(new ChainState(null, requested, ImmutableFilteredList.allOf(this.variantTransforms.getTransforms())));
        ArrayList<CachedVariant> results = new ArrayList<CachedVariant>(1);
        while (results.isEmpty() && !toProcess.isEmpty()) {
            for (ChainState state : toProcess) {
                ImmutableFilteredList<ArtifactTransformRegistration> candidates = state.transforms.matching(transform -> this.matcher.isMatching(transform.getTo(), state.requested));
                for (ArtifactTransformRegistration candidate : candidates) {
                    for (int i = 0; i < sources.size(); ++i) {
                        ImmutableAttributes rootAttrs;
                        ImmutableAttributes sourceAttrs = sources.get(i);
                        if (!this.matcher.isMatching(sourceAttrs, candidate.getFrom()) || !this.matcher.isMatching(rootAttrs = this.attributesFactory.concat(sourceAttrs, candidate.getTo()), state.requested)) continue;
                        DefaultVariantDefinition rootTransformedVariant = new DefaultVariantDefinition(null, rootAttrs, candidate.getTransformationStep());
                        VariantDefinition variantChain = this.createVariantChain(state.chain, rootTransformedVariant);
                        results.add(new CachedVariant(i, variantChain));
                    }
                }
                if (!results.isEmpty()) continue;
                for (int i = 0; i < candidates.size(); ++i) {
                    ArtifactTransformRegistration candidate;
                    candidate = candidates.get(i);
                    nextDepth.add(new ChainState(new ChainNode(state.chain, candidate), this.attributesFactory.concat(state.requested, candidate.getFrom()), state.transforms.withoutIndexFrom(i, candidates)));
                }
            }
            toProcess.clear();
            ArrayList<ChainState> tmp = toProcess;
            toProcess = nextDepth;
            nextDepth = tmp;
        }
        return results;
    }

    private VariantDefinition createVariantChain(ChainNode stateChain, DefaultVariantDefinition root) {
        ChainNode node = stateChain;
        DefaultVariantDefinition last = root;
        while (node != null) {
            last = new DefaultVariantDefinition(last, this.attributesFactory.concat(last.getTargetAttributes(), node.transform.getTo()), node.transform.getTransformationStep());
            node = node.next;
        }
        return last;
    }

    private static class CachingAttributeMatcher {
        private final AttributeMatcher matcher;
        private final ConcurrentHashMap<CacheKey, Boolean> cache = new ConcurrentHashMap();

        public CachingAttributeMatcher(AttributeMatcher matcher) {
            this.matcher = matcher;
        }

        public boolean isMatching(AttributeContainerInternal candidate, AttributeContainerInternal requested) {
            return this.cache.computeIfAbsent(new CacheKey(candidate, requested), key -> this.matcher.isMatching(((CacheKey)key).candidate, ((CacheKey)key).requested));
        }

        private static class CacheKey {
            private final AttributeContainerInternal candidate;
            private final AttributeContainerInternal requested;
            private final int hashCode;

            public CacheKey(AttributeContainerInternal candidate, AttributeContainerInternal requested) {
                this.candidate = candidate;
                this.requested = requested;
                this.hashCode = candidate.hashCode() ^ requested.hashCode();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CacheKey cacheKey = (CacheKey)o;
                return this.candidate.equals(cacheKey.candidate) && this.requested.equals(cacheKey.requested);
            }

            public int hashCode() {
                return this.hashCode;
            }
        }
    }

    private static class TransformationCache {
        private final ConcurrentHashMap<CacheKey, List<CachedVariant>> cache = new ConcurrentHashMap();
        private final BiFunction<List<ImmutableAttributes>, ImmutableAttributes, List<CachedVariant>> action;

        public TransformationCache(BiFunction<List<ImmutableAttributes>, ImmutableAttributes, List<CachedVariant>> action) {
            this.action = action;
        }

        private List<TransformedVariant> query(List<ResolvedVariant> sources, ImmutableAttributes requested) {
            ArrayList<ImmutableAttributes> variantAttributes = new ArrayList<ImmutableAttributes>(sources.size());
            for (ResolvedVariant variant : sources) {
                variantAttributes.add(variant.getAttributes().asImmutable());
            }
            List cached = this.cache.computeIfAbsent(new CacheKey(variantAttributes, requested), key -> this.action.apply(((CacheKey)key).variantAttributes, ((CacheKey)key).requested));
            ArrayList<TransformedVariant> output = new ArrayList<TransformedVariant>(cached.size());
            for (CachedVariant variant : cached) {
                output.add(new TransformedVariant(sources.get(variant.sourceIndex), variant.chain));
            }
            return output;
        }

        private static class CacheKey {
            private final List<ImmutableAttributes> variantAttributes;
            private final ImmutableAttributes requested;
            private final int hashCode;

            public CacheKey(List<ImmutableAttributes> variantAttributes, ImmutableAttributes requested) {
                this.variantAttributes = variantAttributes;
                this.requested = requested;
                this.hashCode = variantAttributes.hashCode() ^ requested.hashCode();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CacheKey cacheKey = (CacheKey)o;
                return this.variantAttributes.equals(cacheKey.variantAttributes) && this.requested.equals(cacheKey.requested);
            }

            public int hashCode() {
                return this.hashCode;
            }
        }
    }

    private static class CachedVariant {
        private final int sourceIndex;
        private final VariantDefinition chain;

        public CachedVariant(int sourceIndex, VariantDefinition chain) {
            this.sourceIndex = sourceIndex;
            this.chain = chain;
        }
    }

    private static class ChainState {
        final ChainNode chain;
        final ImmutableAttributes requested;
        final ImmutableFilteredList<ArtifactTransformRegistration> transforms;

        public ChainState(@Nullable ChainNode chain, ImmutableAttributes requested, ImmutableFilteredList<ArtifactTransformRegistration> transforms) {
            this.chain = chain;
            this.requested = requested;
            this.transforms = transforms;
        }
    }

    private static class ChainNode {
        final ChainNode next;
        final ArtifactTransformRegistration transform;

        public ChainNode(@Nullable ChainNode next, ArtifactTransformRegistration transform) {
            this.next = next;
            this.transform = transform;
        }
    }
}

