/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.FallbackHandlingResourceHasher;
import org.gradle.api.internal.changedetection.state.PropertyResourceBundleFallbackCharset;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.UnionResourceEntryFilter;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileAwareClasspathResourceHasher
extends FallbackHandlingResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileAwareClasspathResourceHasher.class);
    private final Map<PathMatcher, ResourceEntryFilter> propertiesFileFilters;
    private final List<String> propertiesFilePatterns;

    public PropertiesFileAwareClasspathResourceHasher(ResourceHasher delegate, Map<String, ResourceEntryFilter> propertiesFileFilters) {
        super(delegate);
        ImmutableList.Builder patterns = ImmutableList.builder();
        ImmutableMap.Builder filters = ImmutableMap.builder();
        propertiesFileFilters.forEach((pattern, resourceEntryFilter) -> {
            filters.put((Object)PatternMatcherFactory.compile(false, pattern), resourceEntryFilter);
            patterns.add(pattern);
        });
        this.propertiesFileFilters = filters.build();
        this.propertiesFilePatterns = patterns.build();
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        super.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
        this.propertiesFilePatterns.forEach(hasher::putString);
        this.propertiesFileFilters.values().forEach(resourceEntryFilter -> resourceEntryFilter.appendConfigurationToHasher(hasher));
    }

    @Override
    boolean filter(RegularFileSnapshotContext context) {
        return this.matchesAnyFilters(context.getRelativePathSegments());
    }

    @Override
    boolean filter(ZipEntryContext context) {
        return !context.getEntry().isDirectory() && this.matchesAnyFilters(context.getRelativePathSegments());
    }

    @Override
    public Optional<HashCode> tryHash(RegularFileSnapshotContext snapshotContext) {
        return Optional.ofNullable(this.matchingFiltersFor(snapshotContext.getRelativePathSegments())).map(resourceEntryFilter -> {
            HashCode hashCode;
            FileInputStream propertiesFileInputStream = new FileInputStream(snapshotContext.getSnapshot().getAbsolutePath());
            try {
                hashCode = this.hashProperties(propertiesFileInputStream, (ResourceEntryFilter)resourceEntryFilter);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        propertiesFileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.debug("Could not load fingerprint for " + snapshotContext.getSnapshot().getAbsolutePath() + ". Falling back to full entry fingerprinting", (Throwable)e);
                    return null;
                }
            }
            propertiesFileInputStream.close();
            return hashCode;
        });
    }

    @Override
    public Optional<HashCode> tryHash(ZipEntryContext zipEntryContext) {
        return Optional.ofNullable(this.matchingFiltersFor(zipEntryContext.getRelativePathSegments())).map(resourceEntryFilter -> {
            try {
                return zipEntryContext.getEntry().withInputStream(inputStream -> this.hashProperties((InputStream)inputStream, (ResourceEntryFilter)resourceEntryFilter));
            }
            catch (Exception e) {
                LOGGER.debug("Could not load fingerprint for " + zipEntryContext.getRootParentName() + "!" + zipEntryContext.getFullName() + ". Falling back to full entry fingerprinting", (Throwable)e);
                return null;
            }
        });
    }

    private boolean matchesAnyFilters(Supplier<String[]> relativePathSegments) {
        return this.propertiesFileFilters.entrySet().stream().anyMatch(entry -> ((PathMatcher)entry.getKey()).matches((String[])relativePathSegments.get(), 0));
    }

    @Nullable
    private ResourceEntryFilter matchingFiltersFor(Supplier<String[]> relativePathSegments) {
        List<ResourceEntryFilter> matchingFilters = this.propertiesFileFilters.entrySet().stream().filter((? super T entry) -> ((PathMatcher)entry.getKey()).matches((String[])relativePathSegments.get(), 0)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (matchingFilters.size() == 0) {
            return null;
        }
        if (matchingFilters.size() == 1) {
            return (ResourceEntryFilter)matchingFilters.get(0);
        }
        return new UnionResourceEntryFilter(matchingFilters);
    }

    private HashCode hashProperties(InputStream inputStream, ResourceEntryFilter propertyResourceFilter) throws IOException {
        Hasher hasher = Hashing.newHasher();
        Properties properties = new Properties();
        properties.load(new InputStreamReader(inputStream, new PropertyResourceBundleFallbackCharset()));
        ImmutableMap entries = Maps.fromProperties((Properties)properties);
        entries.entrySet().stream().filter((? super T entry) -> !propertyResourceFilter.shouldBeIgnored((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            hasher.putString((CharSequence)entry.getKey());
            hasher.putString((CharSequence)entry.getValue());
        });
        return hasher.hash();
    }
}

