/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.state.ManagedFactory;

public class ManagedFactories {

    public static class DirectoryPropertyManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = DirectoryProperty.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{PUBLIC_TYPE.getName()});
        private final FilePropertyFactory filePropertyFactory;

        public DirectoryPropertyManagedFactory(FilePropertyFactory filePropertyFactory) {
            this.filePropertyFactory = filePropertyFactory;
        }

        @Override
        public <T> T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            return type.cast(this.filePropertyFactory.newDirectoryProperty().value((Provider)Cast.uncheckedNonnullCast(state)));
        }

        @Override
        public int getId() {
            return FACTORY_ID;
        }
    }

    public static class DirectoryManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = Directory.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{PUBLIC_TYPE.getName()});
        private final FileFactory fileFactory;

        public DirectoryManagedFactory(FileFactory fileFactory) {
            this.fileFactory = fileFactory;
        }

        @Override
        public <T> T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            return type.cast(this.fileFactory.dir((File)state));
        }

        @Override
        public int getId() {
            return FACTORY_ID;
        }
    }

    public static class RegularFilePropertyManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = RegularFileProperty.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{PUBLIC_TYPE.getName()});
        private final FilePropertyFactory filePropertyFactory;

        public RegularFilePropertyManagedFactory(FilePropertyFactory filePropertyFactory) {
            this.filePropertyFactory = filePropertyFactory;
        }

        @Override
        public <T> T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            return type.cast(this.filePropertyFactory.newFileProperty().value((Provider)Cast.uncheckedNonnullCast(state)));
        }

        @Override
        public int getId() {
            return FACTORY_ID;
        }
    }

    public static class RegularFileManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = RegularFile.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{PUBLIC_TYPE.getName()});
        private final FileFactory fileFactory;

        public RegularFileManagedFactory(FileFactory fileFactory) {
            this.fileFactory = fileFactory;
        }

        @Override
        public <T> T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            return type.cast(this.fileFactory.file((File)state));
        }

        @Override
        public int getId() {
            return FACTORY_ID;
        }
    }
}

